;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; File: mc56f8006.inc
;; Purpose: Define the peripheral registers for MC56F8006 devices.
;; This file has been generated from the file mc56f8006.h
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define TMR0 Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	TMR0_COMP1      	'$F000' 	;; TMR0
 define 	TMR0_COMP2      	'$F001' 	;; TMR0
 define 	TMR0_CAPT       	'$F002' 	;; TMR0
 define 	TMR0_LOAD       	'$F003' 	;; TMR0
 define 	TMR0_HOLD       	'$F004' 	;; TMR0
 define 	TMR0_CNTR       	'$F005' 	;; TMR0
 define 	TMR0_CTRL       	'$F006' 	;; TMR0
 define 	TMR0_SCTRL      	'$F007' 	;; TMR0
 define 	TMR0_CMPLD1     	'$F008' 	;; TMR0
 define 	TMR0_CMPLD2     	'$F009' 	;; TMR0
 define 	TMR0_CSCTRL     	'$F00A' 	;; TMR0
 define 	TMR0_FILT       	'$F00B' 	;; TMR0
 define 	TMR_ENBL        	'$F00F' 	;; TMR0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define TMR1 Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	TMR1_COMP1      	'$F010' 	;; TMR1
 define 	TMR1_COMP2      	'$F011' 	;; TMR1
 define 	TMR1_CAPT       	'$F012' 	;; TMR1
 define 	TMR1_LOAD       	'$F013' 	;; TMR1
 define 	TMR1_HOLD       	'$F014' 	;; TMR1
 define 	TMR1_CNTR       	'$F015' 	;; TMR1
 define 	TMR1_CTRL       	'$F016' 	;; TMR1
 define 	TMR1_SCTRL      	'$F017' 	;; TMR1
 define 	TMR1_CMPLD1     	'$F018' 	;; TMR1
 define 	TMR1_CMPLD2     	'$F019' 	;; TMR1
 define 	TMR1_CSCTRL     	'$F01A' 	;; TMR1
 define 	TMR1_FILT       	'$F01B' 	;; TMR1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define PWM Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	PWM_CTRL        	'$F020' 	;; PWM
 define 	PWM_FCTRL       	'$F021' 	;; PWM
 define 	PWM_FLTACK      	'$F022' 	;; PWM
 define 	PWM_OUT         	'$F023' 	;; PWM
 define 	PWM_CNTR        	'$F024' 	;; PWM
 define 	PWM_CMOD        	'$F025' 	;; PWM
 define 	PWM_VAL0        	'$F026' 	;; PWM
 define 	PWM_VAL1        	'$F027' 	;; PWM
 define 	PWM_VAL2        	'$F028' 	;; PWM
 define 	PWM_VAL3        	'$F029' 	;; PWM
 define 	PWM_VAL4        	'$F02A' 	;; PWM
 define 	PWM_VAL5        	'$F02B' 	;; PWM
 define 	PWM_DTIM0       	'$F02C' 	;; PWM
 define 	PWM_DTIM1       	'$F02D' 	;; PWM
 define 	PWM_DMAP1       	'$F02E' 	;; PWM
 define 	PWM_DMAP2       	'$F02F' 	;; PWM
 define 	PWM_CNFG        	'$F030' 	;; PWM
 define 	PWM_CCTRL       	'$F031' 	;; PWM
 define 	PWM_PORT        	'$F032' 	;; PWM
 define 	PWM_ICCTRL      	'$F033' 	;; PWM
 define 	PWM_SCTRL       	'$F034' 	;; PWM
 define 	PWM_SYNC        	'$F035' 	;; PWM
 define 	PWM_FFILT0      	'$F036' 	;; PWM
 define 	PWM_FFILT1      	'$F037' 	;; PWM
 define 	PWM_FFILT2      	'$F038' 	;; PWM
 define 	PWM_FFILT3      	'$F039' 	;; PWM

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define INTC Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	INTC_ICSR       	'$F040' 	;; INTC
 define 	INTC_VBA        	'$F041' 	;; INTC
 define 	INTC_IAR0       	'$F042' 	;; INTC
 define 	INTC_IAR1       	'$F043' 	;; INTC
 define 	INTC_IAR2       	'$F044' 	;; INTC

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define ADC0 Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	ADC0_ADCSC1A    	'$F060' 	;; ADC0
 define 	ADC0_ADCSC2     	'$F061' 	;; ADC0
 define 	ADC0_ADCCFG     	'$F066' 	;; ADC0
 define 	ADC0_ADCSC1B    	'$F06A' 	;; ADC0
 define 	ADC0_ADCRA      	'$F06B' 	;; ADC0
 define 	ADC0_ADCRB      	'$F06C' 	;; ADC0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define ADC1 Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	ADC1_ADCSC1A    	'$F080' 	;; ADC1
 define 	ADC1_ADCSC2     	'$F081' 	;; ADC1
 define 	ADC1_ADCCFG     	'$F086' 	;; ADC1
 define 	ADC1_ADCSC1B    	'$F08A' 	;; ADC1
 define 	ADC1_ADCRA      	'$F08B' 	;; ADC1
 define 	ADC1_ADCRB      	'$F08C' 	;; ADC1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define PGA0 Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	PGA0_CNTL0      	'$F0A0' 	;; PGA0
 define 	PGA0_CNTL1      	'$F0A1' 	;; PGA0
 define 	PGA0_CNTL2      	'$F0A2' 	;; PGA0
 define 	PGA0_STS        	'$F0A3' 	;; PGA0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define PGA1 Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	PGA1_CNTL0      	'$F0C0' 	;; PGA1
 define 	PGA1_CNTL1      	'$F0C1' 	;; PGA1
 define 	PGA1_CNTL2      	'$F0C2' 	;; PGA1
 define 	PGA1_STS        	'$F0C3' 	;; PGA1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define SCI Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	SCI_RATE        	'$F0E0' 	;; SCI
 define 	SCI_CTRL1       	'$F0E1' 	;; SCI
 define 	SCI_CTRL2       	'$F0E2' 	;; SCI
 define 	SCI_STAT        	'$F0E3' 	;; SCI
 define 	SCI_DATA        	'$F0E4' 	;; SCI

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define SPI Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	SPI_SCTRL       	'$F100' 	;; SPI
 define 	SPI_DSCTRL      	'$F101' 	;; SPI
 define 	SPI_DRCV        	'$F102' 	;; SPI
 define 	SPI_DXMIT       	'$F103' 	;; SPI

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define I2C Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	I2C_ADDR        	'$F120' 	;; I2C
 define 	I2C_FREQDIV     	'$F121' 	;; I2C
 define 	I2C_CR1         	'$F122' 	;; I2C
 define 	I2C_SR          	'$F123' 	;; I2C
 define 	I2C_DATA        	'$F124' 	;; I2C
 define 	I2C_CR2         	'$F125' 	;; I2C
 define 	I2C_SMB_CSR     	'$F126' 	;; I2C
 define 	I2C_ADDR2       	'$F127' 	;; I2C
 define 	I2C_SLT1        	'$F128' 	;; I2C
 define 	I2C_SLT2        	'$F129' 	;; I2C

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define COP Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	COP_CTRL        	'$F140' 	;; COP
 define 	COP_TOUT        	'$F141' 	;; COP
 define 	COP_CNTR        	'$F142' 	;; COP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define OCCS Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	OCCS_CTRL       	'$F160' 	;; OCCS
 define 	OCCS_DIVBY      	'$F161' 	;; OCCS
 define 	OCCS_STAT       	'$F162' 	;; OCCS
 define 	OCCS_TESTR      	'$F163' 	;; OCCS
 define 	OCCS_OCTRL      	'$F164' 	;; OCCS
 define 	OCCS_CLKCHKR    	'$F165' 	;; OCCS
 define 	OCCS_CLKCHKT    	'$F166' 	;; OCCS
 define 	OCCS_PROT       	'$F167' 	;; OCCS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define GPIOA Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	GPIOA_PUR       	'$F180' 	;; GPIOA
 define 	GPIOA_DR        	'$F181' 	;; GPIOA
 define 	GPIOA_DDR       	'$F182' 	;; GPIOA
 define 	GPIOA_PER       	'$F183' 	;; GPIOA
 define 	GPIOA_IENR      	'$F185' 	;; GPIOA
 define 	GPIOA_IPOLR     	'$F186' 	;; GPIOA
 define 	GPIOA_IPR       	'$F187' 	;; GPIOA
 define 	GPIOA_IESR      	'$F188' 	;; GPIOA
 define 	GPIOA_RAWDATA   	'$F18A' 	;; GPIOA
 define 	GPIOA_DRIVE     	'$F18B' 	;; GPIOA
 define 	GPIOA_IFE       	'$F18C' 	;; GPIOA
 define 	GPIOA_SLEW      	'$F18D' 	;; GPIOA

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define GPIOB Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	GPIOB_PUR       	'$F1A0' 	;; GPIOB
 define 	GPIOB_DR        	'$F1A1' 	;; GPIOB
 define 	GPIOB_DDR       	'$F1A2' 	;; GPIOB
 define 	GPIOB_PER       	'$F1A3' 	;; GPIOB
 define 	GPIOB_IENR      	'$F1A5' 	;; GPIOB
 define 	GPIOB_IPOLR     	'$F1A6' 	;; GPIOB
 define 	GPIOB_IPR       	'$F1A7' 	;; GPIOB
 define 	GPIOB_IESR      	'$F1A8' 	;; GPIOB
 define 	GPIOB_RAWDATA   	'$F1AA' 	;; GPIOB
 define 	GPIOB_DRIVE     	'$F1AB' 	;; GPIOB
 define 	GPIOB_IFE       	'$F1AC' 	;; GPIOB
 define 	GPIOB_SLEW      	'$F1AD' 	;; GPIOB

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define GPIOC Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	GPIOC_PUR       	'$F1C0' 	;; GPIOC
 define 	GPIOC_DR        	'$F1C1' 	;; GPIOC
 define 	GPIOC_DDR       	'$F1C2' 	;; GPIOC
 define 	GPIOC_PER       	'$F1C3' 	;; GPIOC
 define 	GPIOC_IENR      	'$F1C5' 	;; GPIOC
 define 	GPIOC_IPOLR     	'$F1C6' 	;; GPIOC
 define 	GPIOC_IPR       	'$F1C7' 	;; GPIOC
 define 	GPIOC_IESR      	'$F1C8' 	;; GPIOC
 define 	GPIOC_RAWDATA   	'$F1CA' 	;; GPIOC
 define 	GPIOC_DRIVE     	'$F1CB' 	;; GPIOC
 define 	GPIOC_IFE       	'$F1CC' 	;; GPIOC
 define 	GPIOC_SLEW      	'$F1CD' 	;; GPIOC

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define GPIOD Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	GPIOD_PUR       	'$F1E0' 	;; GPIOD
 define 	GPIOD_DR        	'$F1E1' 	;; GPIOD
 define 	GPIOD_DDR       	'$F1E2' 	;; GPIOD
 define 	GPIOD_PER       	'$F1E3' 	;; GPIOD
 define 	GPIOD_IENR      	'$F1E5' 	;; GPIOD
 define 	GPIOD_IPOLR     	'$F1E6' 	;; GPIOD
 define 	GPIOD_IPR       	'$F1E7' 	;; GPIOD
 define 	GPIOD_IESR      	'$F1E8' 	;; GPIOD
 define 	GPIOD_RAWDATA   	'$F1EA' 	;; GPIOD
 define 	GPIOD_DRIVE     	'$F1EB' 	;; GPIOD
 define 	GPIOD_IFE       	'$F1EC' 	;; GPIOD
 define 	GPIOD_SLEW      	'$F1ED' 	;; GPIOD

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define GPIOE Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	GPIOE_PUR       	'$F200' 	;; GPIOE
 define 	GPIOE_DR        	'$F201' 	;; GPIOE
 define 	GPIOE_DDR       	'$F202' 	;; GPIOE
 define 	GPIOE_PER       	'$F203' 	;; GPIOE
 define 	GPIOE_IENR      	'$F205' 	;; GPIOE
 define 	GPIOE_IPOLR     	'$F206' 	;; GPIOE
 define 	GPIOE_IPR       	'$F207' 	;; GPIOE
 define 	GPIOE_IESR      	'$F208' 	;; GPIOE
 define 	GPIOE_RAWDATA   	'$F20A' 	;; GPIOE
 define 	GPIOE_DRIVE     	'$F20B' 	;; GPIOE
 define 	GPIOE_IFE       	'$F20C' 	;; GPIOE
 define 	GPIOE_SLEW      	'$F20D' 	;; GPIOE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define GPIOF Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	GPIOF_PUR       	'$F220' 	;; GPIOF
 define 	GPIOF_DR        	'$F221' 	;; GPIOF
 define 	GPIOF_DDR       	'$F222' 	;; GPIOF
 define 	GPIOF_PER       	'$F223' 	;; GPIOF
 define 	GPIOF_IENR      	'$F225' 	;; GPIOF
 define 	GPIOF_IPOLR     	'$F226' 	;; GPIOF
 define 	GPIOF_IPR       	'$F227' 	;; GPIOF
 define 	GPIOF_IESR      	'$F228' 	;; GPIOF
 define 	GPIOF_RAWDATA   	'$F22A' 	;; GPIOF
 define 	GPIOF_DRIVE     	'$F22B' 	;; GPIOF
 define 	GPIOF_IFE       	'$F22C' 	;; GPIOF
 define 	GPIOF_SLEW      	'$F22D' 	;; GPIOF

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define SIM Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	SIM_CTRL        	'$F240' 	;; SIM
 define 	SIM_RSTAT       	'$F241' 	;; SIM
 define 	SIM_MSHID       	'$F242' 	;; SIM
 define 	SIM_LSHID       	'$F243' 	;; SIM
 define 	SIM_TEST        	'$F244' 	;; SIM
 define 	SIM_CLKOUT      	'$F245' 	;; SIM
 define 	SIM_PCR         	'$F246' 	;; SIM
 define 	SIM_PCE         	'$F247' 	;; SIM
 define 	SIM_SDR         	'$F248' 	;; SIM
 define 	SIM_ISAL        	'$F249' 	;; SIM
 define 	SIM_PROT        	'$F24A' 	;; SIM
 define 	SIM_GPSA        	'$F24B' 	;; SIM
 define 	SIM_GPSB0       	'$F24C' 	;; SIM
 define 	SIM_GPSB1       	'$F24D' 	;; SIM
 define 	SIM_GPSC        	'$F24E' 	;; SIM
 define 	SIM_GPSD        	'$F24F' 	;; SIM
 define 	SIM_IPS0        	'$F250' 	;; SIM
 define 	SIM_IPS1        	'$F251' 	;; SIM

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define PMC Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	PMC_SCR         	'$F260' 	;; PMC
 define 	PMC_CR2         	'$F261' 	;; PMC
 define 	PMC_TESTSC      	'$F262' 	;; PMC

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define CMP0 Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	CMP0_CR0        	'$F280' 	;; CMP0
 define 	CMP0_CR1        	'$F281' 	;; CMP0
 define 	CMP0_FPR        	'$F282' 	;; CMP0
 define 	CMP0_SCR        	'$F283' 	;; CMP0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define CMP1 Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	CMP1_CR0        	'$F2A0' 	;; CMP1
 define 	CMP1_CR1        	'$F2A1' 	;; CMP1
 define 	CMP1_FPR        	'$F2A2' 	;; CMP1
 define 	CMP1_SCR        	'$F2A3' 	;; CMP1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define CMP2 Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	CMP2_CR0        	'$F2C0' 	;; CMP2
 define 	CMP2_CR1        	'$F2C1' 	;; CMP2
 define 	CMP2_FPR        	'$F2C2' 	;; CMP2
 define 	CMP2_SCR        	'$F2C3' 	;; CMP2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define PIT Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	PIT_CTRL        	'$F2E0' 	;; PIT
 define 	PIT_MOD         	'$F2E1' 	;; PIT
 define 	PIT_CNTR        	'$F2E2' 	;; PIT

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define PDB Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	PDB_SCR         	'$F300' 	;; PDB
 define 	PDB_DELAYA      	'$F301' 	;; PDB
 define 	PDB_DELAYB      	'$F302' 	;; PDB
 define 	PDB_MOD         	'$F303' 	;; PDB
 define 	PDB_COUNT       	'$F304' 	;; PDB

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define RTC Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	RTC_SC          	'$F320' 	;; RTC
 define 	RTC_CNT         	'$F321' 	;; RTC
 define 	RTC_MOD         	'$F322' 	;; RTC

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define HFM Registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 define 	FM_CLKDIV       	'$F400' 	;; HFM
 define 	FM_CNFG         	'$F401' 	;; HFM
 define 	FM_TEST         	'$F402' 	;; HFM
 define 	FM_SECHI        	'$F403' 	;; HFM
 define 	FM_SECLO        	'$F404' 	;; HFM
 define 	FM_MONITOR      	'$F405' 	;; HFM
 define 	FM_PROT         	'$F410' 	;; HFM
 define 	FM_TSTAT        	'$F412' 	;; HFM
 define 	FM_USTAT        	'$F413' 	;; HFM
 define 	FM_CMD          	'$F414' 	;; HFM
 define 	FM_CONTROL      	'$F415' 	;; HFM
 define 	FM_ADDR         	'$F416' 	;; HFM
 define 	FM_DATA         	'$F418' 	;; HFM
 define 	FM_OPT0         	'$F41A' 	;; HFM
 define 	FM_OPT1         	'$F41B' 	;; HFM
 define 	FM_MEM_SEL      	'$F41C' 	;; HFM
 define 	FM_TSTSIG       	'$F41D' 	;; HFM

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Generic Bit Definitions Used Elsewhere in this File
 define		BIT0	'$1'
 define		BIT1	'$2'
 define		BIT2	'$4'
 define		BIT3	'$8'
 define		BIT4	'$10'
 define		BIT5	'$20'
 define		BIT6	'$40'
 define		BIT7	'$80'
 define		BIT8	'$100'
 define		BIT9	'$200'
 define		BIT10	'$400'
 define		BIT11	'$800'
 define		BIT12	'$1000'
 define		BIT13	'$2000'
 define		BIT14	'$4000'
 define		BIT15	'$8000'
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; TMR0 Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; TMR0_COMP1 Bit-Fields:
 set TMR0_COMP1_COMPARISON_1        	$FFFF

;; TMR0_COMP2 Bit-Fields:
 set TMR0_COMP2_COMPARISON_2        	$FFFF

;; TMR0_CAPT Bit-Fields:
 set TMR0_CAPT_CAPTURE              	$FFFF

;; TMR0_LOAD Bit-Fields:
 set TMR0_LOAD_LOAD                 	$FFFF

;; TMR0_HOLD Bit-Fields:
 set TMR0_HOLD_HOLD                 	$FFFF

;; TMR0_CNTR Bit-Fields:
 set TMR0_CNTR_COUNTER              	$FFFF

;; TMR0_CTRL Bit-Fields:
 set TMR0_CTRL_CM                   	(BIT15+BIT14+BIT13)
 set TMR0_CTRL_CM_2                 	BIT15
 set TMR0_CTRL_CM_1                 	BIT14
 set TMR0_CTRL_CM_0                 	BIT13
 set TMR0_CTRL_PCS                  	(BIT12+BIT11+BIT10+BIT9)
 set TMR0_CTRL_PCS_3                	BIT12
 set TMR0_CTRL_PCS_2                	BIT11
 set TMR0_CTRL_PCS_1                	BIT10
 set TMR0_CTRL_PCS_0                	BIT9
 set TMR0_CTRL_SCS                  	(BIT8+BIT7)
 set TMR0_CTRL_SCS_1                	BIT8
 set TMR0_CTRL_SCS_0                	BIT7
 set TMR0_CTRL_ONCE                 	BIT6
 set TMR0_CTRL_LENGTH               	BIT5
 set TMR0_CTRL_DIR                  	BIT4
 set TMR0_CTRL_Co_INIT              	BIT3
 set TMR0_CTRL_OM                   	(BIT2+BIT1+BIT0)
 set TMR0_CTRL_OM_2                 	BIT2
 set TMR0_CTRL_OM_1                 	BIT1
 set TMR0_CTRL_OM_0                 	BIT0

;; TMR0_SCTRL Bit-Fields:
 set TMR0_SCTRL_TCF                 	BIT15
 set TMR0_SCTRL_TCFIE               	BIT14
 set TMR0_SCTRL_TOF                 	BIT13
 set TMR0_SCTRL_TOFIE               	BIT12
 set TMR0_SCTRL_IEF                 	BIT11
 set TMR0_SCTRL_IEFIE               	BIT10
 set TMR0_SCTRL_IPS                 	BIT9
 set TMR0_SCTRL_INPUT               	BIT8
 set TMR0_SCTRL_CAPTURE_MODE        	(BIT7+BIT6)
 set TMR0_SCTRL_CAPTURE_MODE_1      	BIT7
 set TMR0_SCTRL_CAPTURE_MODE_0      	BIT6
 set TMR0_SCTRL_MSTR                	BIT5
 set TMR0_SCTRL_EEOF                	BIT4
 set TMR0_SCTRL_VAL                 	BIT3
 set TMR0_SCTRL_FORCE               	BIT2
 set TMR0_SCTRL_OPS                 	BIT1
 set TMR0_SCTRL_OEN                 	BIT0

;; TMR0_CMPLD1 Bit-Fields:
 set TMR0_CMPLD1_COMPARATOR_LOAD_1  	$FFFF

;; TMR0_CMPLD2 Bit-Fields:
 set TMR0_CMPLD2_COMPARATOR_LOAD_2  	$FFFF

;; TMR0_CSCTRL Bit-Fields:
 set TMR0_CSCTRL_DBG_EN             	(BIT15+BIT14)
 set TMR0_CSCTRL_DBG_EN_1           	BIT15
 set TMR0_CSCTRL_DBG_EN_0           	BIT14
 set TMR0_CSCTRL_TCF2EN             	BIT7
 set TMR0_CSCTRL_TCF1EN             	BIT6
 set TMR0_CSCTRL_TCF2               	BIT5
 set TMR0_CSCTRL_TCF1               	BIT4
 set TMR0_CSCTRL_CL2                	(BIT3+BIT2)
 set TMR0_CSCTRL_CL2_1              	BIT3
 set TMR0_CSCTRL_CL2_0              	BIT2
 set TMR0_CSCTRL_CL1                	(BIT1+BIT0)
 set TMR0_CSCTRL_CL1_1              	BIT1
 set TMR0_CSCTRL_CL1_0              	BIT0

;; TMR0_FILT Bit-Fields:
 set TMR0_FILT_FILT_CNT             	(BIT10+BIT9+BIT8)
 set TMR0_FILT_FILT_CNT_2           	BIT10
 set TMR0_FILT_FILT_CNT_1           	BIT9
 set TMR0_FILT_FILT_CNT_0           	BIT8
 set TMR0_FILT_FILT_PER             	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set TMR0_FILT_FILT_PER_7           	BIT7
 set TMR0_FILT_FILT_PER_6           	BIT6
 set TMR0_FILT_FILT_PER_5           	BIT5
 set TMR0_FILT_FILT_PER_4           	BIT4
 set TMR0_FILT_FILT_PER_3           	BIT3
 set TMR0_FILT_FILT_PER_2           	BIT2
 set TMR0_FILT_FILT_PER_1           	BIT1
 set TMR0_FILT_FILT_PER_0           	BIT0

;; TMR_ENBL Bit-Fields:
 set TMR_ENBL_ENBL                  	(BIT1+BIT0)
 set TMR_ENBL_ENBL_1                	BIT1
 set TMR_ENBL_ENBL_0                	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; TMR1 Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; TMR1_COMP1 Bit-Fields:
 set TMR1_COMP1_COMPARISON_1        	$FFFF

;; TMR1_COMP2 Bit-Fields:
 set TMR1_COMP2_COMPARISON_2        	$FFFF

;; TMR1_CAPT Bit-Fields:
 set TMR1_CAPT_CAPTURE              	$FFFF

;; TMR1_LOAD Bit-Fields:
 set TMR1_LOAD_LOAD                 	$FFFF

;; TMR1_HOLD Bit-Fields:
 set TMR1_HOLD_HOLD                 	$FFFF

;; TMR1_CNTR Bit-Fields:
 set TMR1_CNTR_COUNTER              	$FFFF

;; TMR1_CTRL Bit-Fields:
 set TMR1_CTRL_CM                   	(BIT15+BIT14+BIT13)
 set TMR1_CTRL_CM_2                 	BIT15
 set TMR1_CTRL_CM_1                 	BIT14
 set TMR1_CTRL_CM_0                 	BIT13
 set TMR1_CTRL_PCS                  	(BIT12+BIT11+BIT10+BIT9)
 set TMR1_CTRL_PCS_3                	BIT12
 set TMR1_CTRL_PCS_2                	BIT11
 set TMR1_CTRL_PCS_1                	BIT10
 set TMR1_CTRL_PCS_0                	BIT9
 set TMR1_CTRL_SCS                  	(BIT8+BIT7)
 set TMR1_CTRL_SCS_1                	BIT8
 set TMR1_CTRL_SCS_0                	BIT7
 set TMR1_CTRL_ONCE                 	BIT6
 set TMR1_CTRL_LENGTH               	BIT5
 set TMR1_CTRL_DIR                  	BIT4
 set TMR1_CTRL_Co_INIT              	BIT3
 set TMR1_CTRL_OM                   	(BIT2+BIT1+BIT0)
 set TMR1_CTRL_OM_2                 	BIT2
 set TMR1_CTRL_OM_1                 	BIT1
 set TMR1_CTRL_OM_0                 	BIT0

;; TMR1_SCTRL Bit-Fields:
 set TMR1_SCTRL_TCF                 	BIT15
 set TMR1_SCTRL_TCFIE               	BIT14
 set TMR1_SCTRL_TOF                 	BIT13
 set TMR1_SCTRL_TOFIE               	BIT12
 set TMR1_SCTRL_IEF                 	BIT11
 set TMR1_SCTRL_IEFIE               	BIT10
 set TMR1_SCTRL_IPS                 	BIT9
 set TMR1_SCTRL_INPUT               	BIT8
 set TMR1_SCTRL_CAPTURE_MODE        	(BIT7+BIT6)
 set TMR1_SCTRL_CAPTURE_MODE_1      	BIT7
 set TMR1_SCTRL_CAPTURE_MODE_0      	BIT6
 set TMR1_SCTRL_MSTR                	BIT5
 set TMR1_SCTRL_EEOF                	BIT4
 set TMR1_SCTRL_VAL                 	BIT3
 set TMR1_SCTRL_FORCE               	BIT2
 set TMR1_SCTRL_OPS                 	BIT1
 set TMR1_SCTRL_OEN                 	BIT0

;; TMR1_CMPLD1 Bit-Fields:
 set TMR1_CMPLD1_COMPARATOR_LOAD_1  	$FFFF

;; TMR1_CMPLD2 Bit-Fields:
 set TMR1_CMPLD2_COMPARATOR_LOAD_2  	$FFFF

;; TMR1_CSCTRL Bit-Fields:
 set TMR1_CSCTRL_DBG_EN             	(BIT15+BIT14)
 set TMR1_CSCTRL_DBG_EN_1           	BIT15
 set TMR1_CSCTRL_DBG_EN_0           	BIT14
 set TMR1_CSCTRL_TCF2EN             	BIT7
 set TMR1_CSCTRL_TCF1EN             	BIT6
 set TMR1_CSCTRL_TCF2               	BIT5
 set TMR1_CSCTRL_TCF1               	BIT4
 set TMR1_CSCTRL_CL2                	(BIT3+BIT2)
 set TMR1_CSCTRL_CL2_1              	BIT3
 set TMR1_CSCTRL_CL2_0              	BIT2
 set TMR1_CSCTRL_CL1                	(BIT1+BIT0)
 set TMR1_CSCTRL_CL1_1              	BIT1
 set TMR1_CSCTRL_CL1_0              	BIT0

;; TMR1_FILT Bit-Fields:
 set TMR1_FILT_FILT_CNT             	(BIT10+BIT9+BIT8)
 set TMR1_FILT_FILT_CNT_2           	BIT10
 set TMR1_FILT_FILT_CNT_1           	BIT9
 set TMR1_FILT_FILT_CNT_0           	BIT8
 set TMR1_FILT_FILT_PER             	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set TMR1_FILT_FILT_PER_7           	BIT7
 set TMR1_FILT_FILT_PER_6           	BIT6
 set TMR1_FILT_FILT_PER_5           	BIT5
 set TMR1_FILT_FILT_PER_4           	BIT4
 set TMR1_FILT_FILT_PER_3           	BIT3
 set TMR1_FILT_FILT_PER_2           	BIT2
 set TMR1_FILT_FILT_PER_1           	BIT1
 set TMR1_FILT_FILT_PER_0           	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; PWM Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; PWM_CTRL Bit-Fields:
 set PWM_CTRL_LDFQ                  	(BIT15+BIT14+BIT13+BIT12)
 set PWM_CTRL_LDFQ_3                	BIT15
 set PWM_CTRL_LDFQ_2                	BIT14
 set PWM_CTRL_LDFQ_1                	BIT13
 set PWM_CTRL_LDFQ_0                	BIT12
 set PWM_CTRL_HALF                  	BIT11
 set PWM_CTRL_IPOL2                 	BIT10
 set PWM_CTRL_IPOL1                 	BIT9
 set PWM_CTRL_IPOL0                 	BIT8
 set PWM_CTRL_PRSC                  	(BIT7+BIT6)
 set PWM_CTRL_PRSC_1                	BIT7
 set PWM_CTRL_PRSC_0                	BIT6
 set PWM_CTRL_PWMRIE                	BIT5
 set PWM_CTRL_PWMF                  	BIT4
 set PWM_CTRL_ISENS                 	(BIT3+BIT2)
 set PWM_CTRL_ISENS_1               	BIT3
 set PWM_CTRL_ISENS_0               	BIT2
 set PWM_CTRL_LDOK                  	BIT1
 set PWM_CTRL_PWMEN                 	BIT0

;; PWM_FCTRL Bit-Fields:
 set PWM_FCTRL_FPOL3                	BIT11
 set PWM_FCTRL_FPOL2                	BIT10
 set PWM_FCTRL_FPOL1                	BIT9
 set PWM_FCTRL_FPOL0                	BIT8
 set PWM_FCTRL_FIE3                 	BIT7
 set PWM_FCTRL_FMODE3               	BIT6
 set PWM_FCTRL_FIE2                 	BIT5
 set PWM_FCTRL_FMODE2               	BIT4
 set PWM_FCTRL_FIE1                 	BIT3
 set PWM_FCTRL_FMODE1               	BIT2
 set PWM_FCTRL_FIE0                 	BIT1
 set PWM_FCTRL_FMODE0               	BIT0

;; PWM_FLTACK Bit-Fields:
 set PWM_FLTACK_FPIN3               	BIT15
 set PWM_FLTACK_FFLAG3              	BIT14
 set PWM_FLTACK_FPIN2               	BIT13
 set PWM_FLTACK_FFLAG2              	BIT12
 set PWM_FLTACK_FPIN1               	BIT11
 set PWM_FLTACK_FFLAG1              	BIT10
 set PWM_FLTACK_FPIN0               	BIT9
 set PWM_FLTACK_FFLAG0              	BIT8
 set PWM_FLTACK_FTACL3              	BIT6
 set PWM_FLTACK_DT5                 	BIT5
 set PWM_FLTACK_DT4_FTACK2          	BIT4
 set PWM_FLTACK_Dt3                 	BIT3
 set PWM_FLTACK_DT2_FTACK1          	BIT2
 set PWM_FLTACK_DT1                 	BIT1
 set PWM_FLTACK_DT0_FTACK0          	BIT0

;; PWM_OUT Bit-Fields:
 set PWM_OUT_PAD_EN                 	BIT15
 set PWM_OUT_OUTCTL5                	BIT13
 set PWM_OUT_OUTCTL4                	BIT12
 set PWM_OUT_OUTCTL3                	BIT11
 set PWM_OUT_OUTCTL2                	BIT10
 set PWM_OUT_OUTCTL1                	BIT9
 set PWM_OUT_OUTCTL0                	BIT8
 set PWM_OUT_OUt5                   	BIT5
 set PWM_OUT_OUT4                   	BIT4
 set PWM_OUT_OUT3                   	BIT3
 set PWM_OUT_OUT2                   	BIT2
 set PWM_OUT_OUT1                   	BIT1
 set PWM_OUT_OUT0                   	BIT0

;; PWM_CNTR Bit-Fields:
 set PWM_CNTR_CR                    	(BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set PWM_CNTR_CR_14                 	BIT14
 set PWM_CNTR_CR_13                 	BIT13
 set PWM_CNTR_CR_12                 	BIT12
 set PWM_CNTR_CR_11                 	BIT11
 set PWM_CNTR_CR_10                 	BIT10
 set PWM_CNTR_CR_9                  	BIT9
 set PWM_CNTR_CR_8                  	BIT8
 set PWM_CNTR_CR_7                  	BIT7
 set PWM_CNTR_CR_6                  	BIT6
 set PWM_CNTR_CR_5                  	BIT5
 set PWM_CNTR_CR_4                  	BIT4
 set PWM_CNTR_CR_3                  	BIT3
 set PWM_CNTR_CR_2                  	BIT2
 set PWM_CNTR_CR_1                  	BIT1
 set PWM_CNTR_CR_0                  	BIT0

;; PWM_CMOD Bit-Fields:
 set PWM_CMOD_PWMCM                 	(BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set PWM_CMOD_PWMCM_14              	BIT14
 set PWM_CMOD_PWMCM_13              	BIT13
 set PWM_CMOD_PWMCM_12              	BIT12
 set PWM_CMOD_PWMCM_11              	BIT11
 set PWM_CMOD_PWMCM_10              	BIT10
 set PWM_CMOD_PWMCM_9               	BIT9
 set PWM_CMOD_PWMCM_8               	BIT8
 set PWM_CMOD_PWMCM_7               	BIT7
 set PWM_CMOD_PWMCM_6               	BIT6
 set PWM_CMOD_PWMCM_5               	BIT5
 set PWM_CMOD_PWMCM_4               	BIT4
 set PWM_CMOD_PWMCM_3               	BIT3
 set PWM_CMOD_PWMCM_2               	BIT2
 set PWM_CMOD_PWMCM_1               	BIT1
 set PWM_CMOD_PWMCM_0               	BIT0

;; PWM_VAL0 Bit-Fields:
 set PWM_VAL0_PMVAL                 	$FFFF

;; PWM_VAL1 Bit-Fields:
 set PWM_VAL1_PMVAL                 	$FFFF

;; PWM_VAL2 Bit-Fields:
 set PWM_VAL2_PMVAL                 	$FFFF

;; PWM_VAL3 Bit-Fields:
 set PWM_VAL3_PMVAL                 	$FFFF

;; PWM_VAL4 Bit-Fields:
 set PWM_VAL4_PMVAL                 	$FFFF

;; PWM_VAL5 Bit-Fields:
 set PWM_VAL5_PMVAL                 	$FFFF

;; PWM_DTIM0 Bit-Fields:
 set PWM_DTIM0_PWMDT0               	(BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set PWM_DTIM0_PWMDT0_11            	BIT11
 set PWM_DTIM0_PWMDT0_10            	BIT10
 set PWM_DTIM0_PWMDT0_9             	BIT9
 set PWM_DTIM0_PWMDT0_8             	BIT8
 set PWM_DTIM0_PWMDT0_7             	BIT7
 set PWM_DTIM0_PWMDT0_6             	BIT6
 set PWM_DTIM0_PWMDT0_5             	BIT5
 set PWM_DTIM0_PWMDT0_4             	BIT4
 set PWM_DTIM0_PWMDT0_3             	BIT3
 set PWM_DTIM0_PWMDT0_2             	BIT2
 set PWM_DTIM0_PWMDT0_1             	BIT1
 set PWM_DTIM0_PWMDT0_0             	BIT0

;; PWM_DTIM1 Bit-Fields:
 set PWM_DTIM1_PWMDT1               	(BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set PWM_DTIM1_PWMDT1_11            	BIT11
 set PWM_DTIM1_PWMDT1_10            	BIT10
 set PWM_DTIM1_PWMDT1_9             	BIT9
 set PWM_DTIM1_PWMDT1_8             	BIT8
 set PWM_DTIM1_PWMDT1_7             	BIT7
 set PWM_DTIM1_PWMDT1_6             	BIT6
 set PWM_DTIM1_PWMDT1_5             	BIT5
 set PWM_DTIM1_PWMDT1_4             	BIT4
 set PWM_DTIM1_PWMDT1_3             	BIT3
 set PWM_DTIM1_PWMDT1_2             	BIT2
 set PWM_DTIM1_PWMDT1_1             	BIT1
 set PWM_DTIM1_PWMDT1_0             	BIT0

;; PWM_DMAP1 Bit-Fields:
 set PWM_DMAP1_DISMAP_15_0          	$FFFF

;; PWM_DMAP2 Bit-Fields:
 set PWM_DMAP2_DISMAP_23_16         	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set PWM_DMAP2_DISMAP_23_16_7       	BIT7
 set PWM_DMAP2_DISMAP_23_16_6       	BIT6
 set PWM_DMAP2_DISMAP_23_16_5       	BIT5
 set PWM_DMAP2_DISMAP_23_16_4       	BIT4
 set PWM_DMAP2_DISMAP_23_16_3       	BIT3
 set PWM_DMAP2_DISMAP_23_16_2       	BIT2
 set PWM_DMAP2_DISMAP_23_16_1       	BIT1
 set PWM_DMAP2_DISMAP_23_16_0       	BIT0

;; PWM_CNFG Bit-Fields:
 set PWM_CNFG_DBG_EN                	BIT14
 set PWM_CNFG_WAIT_EN               	BIT13
 set PWM_CNFG_EDG                   	BIT12
 set PWM_CNFG_TOPNEG45              	BIT10
 set PWM_CNFG_TOPNEG23              	BIT9
 set PWM_CNFG_TOPNEG01              	BIT8
 set PWM_CNFG_BOTNEG45              	BIT6
 set PWM_CNFG_BOTNEG23              	BIT5
 set PWM_CNFG_BOTNEG01              	BIT4
 set PWM_CNFG_INDEP45               	BIT3
 set PWM_CNFG_INDEP23               	BIT2
 set PWM_CNFG_INDEP01               	BIT1
 set PWM_CNFG_WP                    	BIT0

;; PWM_CCTRL Bit-Fields:
 set PWM_CCTRL_ENHA                 	BIT15
 set PWM_CCTRL_nBX                  	BIT14
 set PWM_CCTRL_MSK5                 	BIT13
 set PWM_CCTRL_MSK4                 	BIT12
 set PWM_CCTRL_MSK3                 	BIT11
 set PWM_CCTRL_MSK2                 	BIT10
 set PWM_CCTRL_MSK1                 	BIT9
 set PWM_CCTRL_MSK0                 	BIT8
 set PWM_CCTRL_VLMODE               	(BIT5+BIT4)
 set PWM_CCTRL_VLMODE_1             	BIT5
 set PWM_CCTRL_VLMODE_0             	BIT4
 set PWM_CCTRL_SWP45                	BIT2
 set PWM_CCTRL_SWP23                	BIT1
 set PWM_CCTRL_SWP01                	BIT0

;; PWM_PORT Bit-Fields:
 set PWM_PORT_PORT                  	(BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set PWM_PORT_PORT_6                	BIT6
 set PWM_PORT_PORT_5                	BIT5
 set PWM_PORT_PORT_4                	BIT4
 set PWM_PORT_PORT_3                	BIT3
 set PWM_PORT_PORT_2                	BIT2
 set PWM_PORT_PORT_1                	BIT1
 set PWM_PORT_PORT_0                	BIT0

;; PWM_ICCTRL Bit-Fields:
 set PWM_ICCTRL_PEC2                	BIT5
 set PWM_ICCTRL_PEC1                	BIT4
 set PWM_ICCTRL_PEC0                	BIT3
 set PWM_ICCTRL_ICC2                	BIT2
 set PWM_ICCTRL_ICC1                	BIT1
 set PWM_ICCTRL_ICC0                	BIT0

;; PWM_SCTRL Bit-Fields:
 set PWM_SCTRL_CINV5                	BIT13
 set PWM_SCTRL_CINV4                	BIT12
 set PWM_SCTRL_CINV3                	BIT11
 set PWM_SCTRL_CINV2                	BIT10
 set PWM_SCTRL_CINV1                	BIT9
 set PWM_SCTRL_CINV0                	BIT8
 set PWM_SCTRL_SRC2                 	(BIT6+BIT5)
 set PWM_SCTRL_SRC2_1               	BIT6
 set PWM_SCTRL_SRC2_0               	BIT5
 set PWM_SCTRL_SRC1                 	(BIT3+BIT2)
 set PWM_SCTRL_SRC1_1               	BIT3
 set PWM_SCTRL_SRC1_0               	BIT2
 set PWM_SCTRL_SRC0                 	BIT0

;; PWM_SYNC Bit-Fields:
 set PWM_SYNC_SYNC_OUT_EN           	BIT15
 set PWM_SYNC_SYNC_WINDOW           	(BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set PWM_SYNC_SYNC_WINDOW_14        	BIT14
 set PWM_SYNC_SYNC_WINDOW_13        	BIT13
 set PWM_SYNC_SYNC_WINDOW_12        	BIT12
 set PWM_SYNC_SYNC_WINDOW_11        	BIT11
 set PWM_SYNC_SYNC_WINDOW_10        	BIT10
 set PWM_SYNC_SYNC_WINDOW_9         	BIT9
 set PWM_SYNC_SYNC_WINDOW_8         	BIT8
 set PWM_SYNC_SYNC_WINDOW_7         	BIT7
 set PWM_SYNC_SYNC_WINDOW_6         	BIT6
 set PWM_SYNC_SYNC_WINDOW_5         	BIT5
 set PWM_SYNC_SYNC_WINDOW_4         	BIT4
 set PWM_SYNC_SYNC_WINDOW_3         	BIT3
 set PWM_SYNC_SYNC_WINDOW_2         	BIT2
 set PWM_SYNC_SYNC_WINDOW_1         	BIT1
 set PWM_SYNC_SYNC_WINDOW_0         	BIT0

;; PWM_FFILT0 Bit-Fields:
 set PWM_FFILT0_FILT0_CNT           	(BIT10+BIT9+BIT8)
 set PWM_FFILT0_FILT0_CNT_2         	BIT10
 set PWM_FFILT0_FILT0_CNT_1         	BIT9
 set PWM_FFILT0_FILT0_CNT_0         	BIT8
 set PWM_FFILT0_FILT0_PER           	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set PWM_FFILT0_FILT0_PER_7         	BIT7
 set PWM_FFILT0_FILT0_PER_6         	BIT6
 set PWM_FFILT0_FILT0_PER_5         	BIT5
 set PWM_FFILT0_FILT0_PER_4         	BIT4
 set PWM_FFILT0_FILT0_PER_3         	BIT3
 set PWM_FFILT0_FILT0_PER_2         	BIT2
 set PWM_FFILT0_FILT0_PER_1         	BIT1
 set PWM_FFILT0_FILT0_PER_0         	BIT0

;; PWM_FFILT1 Bit-Fields:
 set PWM_FFILT1_FILT1_CNT           	(BIT10+BIT9+BIT8)
 set PWM_FFILT1_FILT1_CNT_2         	BIT10
 set PWM_FFILT1_FILT1_CNT_1         	BIT9
 set PWM_FFILT1_FILT1_CNT_0         	BIT8
 set PWM_FFILT1_FILT1_PER           	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set PWM_FFILT1_FILT1_PER_7         	BIT7
 set PWM_FFILT1_FILT1_PER_6         	BIT6
 set PWM_FFILT1_FILT1_PER_5         	BIT5
 set PWM_FFILT1_FILT1_PER_4         	BIT4
 set PWM_FFILT1_FILT1_PER_3         	BIT3
 set PWM_FFILT1_FILT1_PER_2         	BIT2
 set PWM_FFILT1_FILT1_PER_1         	BIT1
 set PWM_FFILT1_FILT1_PER_0         	BIT0

;; PWM_FFILT2 Bit-Fields:
 set PWM_FFILT2_FILT2_CNT           	(BIT10+BIT9+BIT8)
 set PWM_FFILT2_FILT2_CNT_2         	BIT10
 set PWM_FFILT2_FILT2_CNT_1         	BIT9
 set PWM_FFILT2_FILT2_CNT_0         	BIT8
 set PWM_FFILT2_FILT2_PER           	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set PWM_FFILT2_FILT2_PER_7         	BIT7
 set PWM_FFILT2_FILT2_PER_6         	BIT6
 set PWM_FFILT2_FILT2_PER_5         	BIT5
 set PWM_FFILT2_FILT2_PER_4         	BIT4
 set PWM_FFILT2_FILT2_PER_3         	BIT3
 set PWM_FFILT2_FILT2_PER_2         	BIT2
 set PWM_FFILT2_FILT2_PER_1         	BIT1
 set PWM_FFILT2_FILT2_PER_0         	BIT0

;; PWM_FFILT3 Bit-Fields:
 set PWM_FFILT3_FILT3_CNT           	(BIT10+BIT9+BIT8)
 set PWM_FFILT3_FILT3_CNT_2         	BIT10
 set PWM_FFILT3_FILT3_CNT_1         	BIT9
 set PWM_FFILT3_FILT3_CNT_0         	BIT8
 set PWM_FFILT3_FILT3_PER           	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set PWM_FFILT3_FILT3_PER_7         	BIT7
 set PWM_FFILT3_FILT3_PER_6         	BIT6
 set PWM_FFILT3_FILT3_PER_5         	BIT5
 set PWM_FFILT3_FILT3_PER_4         	BIT4
 set PWM_FFILT3_FILT3_PER_3         	BIT3
 set PWM_FFILT3_FILT3_PER_2         	BIT2
 set PWM_FFILT3_FILT3_PER_1         	BIT1
 set PWM_FFILT3_FILT3_PER_0         	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; INTC Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; INTC_ICSR Bit-Fields:
 set INTC_ICSR_INT                  	BIT15
 set INTC_ICSR_IPIC                 	(BIT14+BIT13)
 set INTC_ICSR_IPIC_1               	BIT14
 set INTC_ICSR_IPIC_0               	BIT13
 set INTC_ICSR_VAB                  	(BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6)
 set INTC_ICSR_VAB_6                	BIT12
 set INTC_ICSR_VAB_5                	BIT11
 set INTC_ICSR_VAB_4                	BIT10
 set INTC_ICSR_VAB_3                	BIT9
 set INTC_ICSR_VAB_2                	BIT8
 set INTC_ICSR_VAB_1                	BIT7
 set INTC_ICSR_VAB_0                	BIT6
 set INTC_ICSR_INT_DIS              	BIT5
 set INTC_ICSR_ERRF                 	BIT4
 set INTC_ICSR_ETRE                 	BIT3
 set INTC_ICSR_TRBUF                	BIT2
 set INTC_ICSR_BKPT                 	BIT1
 set INTC_ICSR_STPCNT               	BIT0

;; INTC_VBA Bit-Fields:
 set INTC_VBA_VECTOR_BASE_ADDRESS   	(BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set INTC_VBA_VECTOR_BASE_ADDRESS_13 	BIT13
 set INTC_VBA_VECTOR_BASE_ADDRESS_12 	BIT12
 set INTC_VBA_VECTOR_BASE_ADDRESS_11 	BIT11
 set INTC_VBA_VECTOR_BASE_ADDRESS_10 	BIT10
 set INTC_VBA_VECTOR_BASE_ADDRESS_9 	BIT9
 set INTC_VBA_VECTOR_BASE_ADDRESS_8 	BIT8
 set INTC_VBA_VECTOR_BASE_ADDRESS_7 	BIT7
 set INTC_VBA_VECTOR_BASE_ADDRESS_6 	BIT6
 set INTC_VBA_VECTOR_BASE_ADDRESS_5 	BIT5
 set INTC_VBA_VECTOR_BASE_ADDRESS_4 	BIT4
 set INTC_VBA_VECTOR_BASE_ADDRESS_3 	BIT3
 set INTC_VBA_VECTOR_BASE_ADDRESS_2 	BIT2
 set INTC_VBA_VECTOR_BASE_ADDRESS_1 	BIT1
 set INTC_VBA_VECTOR_BASE_ADDRESS_0 	BIT0

;; INTC_IAR0 Bit-Fields:
 set INTC_IAR0_USER2                	(BIT13+BIT12+BIT11+BIT10+BIT9+BIT8)
 set INTC_IAR0_USER2_5              	BIT13
 set INTC_IAR0_USER2_4              	BIT12
 set INTC_IAR0_USER2_3              	BIT11
 set INTC_IAR0_USER2_2              	BIT10
 set INTC_IAR0_USER2_1              	BIT9
 set INTC_IAR0_USER2_0              	BIT8
 set INTC_IAR0_USER1                	(BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set INTC_IAR0_USER1_5              	BIT5
 set INTC_IAR0_USER1_4              	BIT4
 set INTC_IAR0_USER1_3              	BIT3
 set INTC_IAR0_USER1_2              	BIT2
 set INTC_IAR0_USER1_1              	BIT1
 set INTC_IAR0_USER1_0              	BIT0

;; INTC_IAR1 Bit-Fields:
 set INTC_IAR1_USER4                	(BIT13+BIT12+BIT11+BIT10+BIT9+BIT8)
 set INTC_IAR1_USER4_5              	BIT13
 set INTC_IAR1_USER4_4              	BIT12
 set INTC_IAR1_USER4_3              	BIT11
 set INTC_IAR1_USER4_2              	BIT10
 set INTC_IAR1_USER4_1              	BIT9
 set INTC_IAR1_USER4_0              	BIT8
 set INTC_IAR1_USER3                	(BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set INTC_IAR1_USER3_5              	BIT5
 set INTC_IAR1_USER3_4              	BIT4
 set INTC_IAR1_USER3_3              	BIT3
 set INTC_IAR1_USER3_2              	BIT2
 set INTC_IAR1_USER3_1              	BIT1
 set INTC_IAR1_USER3_0              	BIT0

;; INTC_IAR2 Bit-Fields:
 set INTC_IAR2_USER6                	(BIT13+BIT12+BIT11+BIT10+BIT9+BIT8)
 set INTC_IAR2_USER6_5              	BIT13
 set INTC_IAR2_USER6_4              	BIT12
 set INTC_IAR2_USER6_3              	BIT11
 set INTC_IAR2_USER6_2              	BIT10
 set INTC_IAR2_USER6_1              	BIT9
 set INTC_IAR2_USER6_0              	BIT8
 set INTC_IAR2_USER5                	(BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set INTC_IAR2_USER5_5              	BIT5
 set INTC_IAR2_USER5_4              	BIT4
 set INTC_IAR2_USER5_3              	BIT3
 set INTC_IAR2_USER5_2              	BIT2
 set INTC_IAR2_USER5_1              	BIT1
 set INTC_IAR2_USER5_0              	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ADC0 Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ADC0_ADCSC1A Bit-Fields:
 set ADC0_ADCSC1A_COCO              	BIT7
 set ADC0_ADCSC1A_AIEN              	BIT6
 set ADC0_ADCSC1A_ADCO              	BIT5
 set ADC0_ADCSC1A_ADCH              	(BIT4+BIT3+BIT2+BIT1+BIT0)
 set ADC0_ADCSC1A_ADCH_4            	BIT4
 set ADC0_ADCSC1A_ADCH_3            	BIT3
 set ADC0_ADCSC1A_ADCH_2            	BIT2
 set ADC0_ADCSC1A_ADCH_1            	BIT1
 set ADC0_ADCSC1A_ADCH_0            	BIT0

;; ADC0_ADCSC2 Bit-Fields:
 set ADC0_ADCSC2_ADACT              	BIT7
 set ADC0_ADCSC2_ADTRG              	BIT6
 set ADC0_ADCSC2_ECC                	BIT2
 set ADC0_ADCSC2_REFSEL             	(BIT1+BIT0)
 set ADC0_ADCSC2_REFSEL_1           	BIT1
 set ADC0_ADCSC2_REFSEL_0           	BIT0

;; ADC0_ADCCFG Bit-Fields:
 set ADC0_ADCCFG_ADLPC              	BIT7
 set ADC0_ADCCFG_ADIV               	(BIT6+BIT5)
 set ADC0_ADCCFG_ADIV_1             	BIT6
 set ADC0_ADCCFG_ADIV_0             	BIT5
 set ADC0_ADCCFG_ADLSMP             	BIT4
 set ADC0_ADCCFG_MODE               	(BIT3+BIT2)
 set ADC0_ADCCFG_MODE_1             	BIT3
 set ADC0_ADCCFG_MODE_0             	BIT2
 set ADC0_ADCCFG_ADICLK             	(BIT1+BIT0)
 set ADC0_ADCCFG_ADICLK_1           	BIT1
 set ADC0_ADCCFG_ADICLK_0           	BIT0

;; ADC0_ADCSC1B Bit-Fields:
 set ADC0_ADCSC1B_COCO              	BIT7
 set ADC0_ADCSC1B_AIEN              	BIT6
 set ADC0_ADCSC1B_ADCO              	BIT5
 set ADC0_ADCSC1B_ADCH              	(BIT4+BIT3+BIT2+BIT1+BIT0)
 set ADC0_ADCSC1B_ADCH_4            	BIT4
 set ADC0_ADCSC1B_ADCH_3            	BIT3
 set ADC0_ADCSC1B_ADCH_2            	BIT2
 set ADC0_ADCSC1B_ADCH_1            	BIT1
 set ADC0_ADCSC1B_ADCH_0            	BIT0

;; ADC0_ADCRA Bit-Fields:
 set ADC0_ADCRA_ADR11               	BIT14
 set ADC0_ADCRA_ADR10               	BIT13
 set ADC0_ADCRA_ADR9                	BIT12
 set ADC0_ADCRA_ADR8                	BIT11
 set ADC0_ADCRA_ADR7                	BIT10
 set ADC0_ADCRA_ADR6                	BIT9
 set ADC0_ADCRA_ADR5                	BIT8
 set ADC0_ADCRA_ADR4                	BIT7
 set ADC0_ADCRA_ADR3                	BIT6
 set ADC0_ADCRA_ADR2                	BIT5
 set ADC0_ADCRA_ADR1                	BIT4
 set ADC0_ADCRA_ADR0                	BIT3

;; ADC0_ADCRB Bit-Fields:
 set ADC0_ADCRB_ADR11               	BIT14
 set ADC0_ADCRB_ADR10               	BIT13
 set ADC0_ADCRB_ADR9                	BIT12
 set ADC0_ADCRB_ADR8                	BIT11
 set ADC0_ADCRB_ADR7                	BIT10
 set ADC0_ADCRB_ADR6                	BIT9
 set ADC0_ADCRB_ADR5                	BIT8
 set ADC0_ADCRB_ADR4                	BIT7
 set ADC0_ADCRB_ADR3                	BIT6
 set ADC0_ADCRB_ADR2                	BIT5
 set ADC0_ADCRB_ADR1                	BIT4
 set ADC0_ADCRB_ADR0                	BIT3

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ADC1 Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ADC1_ADCSC1A Bit-Fields:
 set ADC1_ADCSC1A_COCO              	BIT7
 set ADC1_ADCSC1A_AIEN              	BIT6
 set ADC1_ADCSC1A_ADCO              	BIT5
 set ADC1_ADCSC1A_ADCH              	(BIT4+BIT3+BIT2+BIT1+BIT0)
 set ADC1_ADCSC1A_ADCH_4            	BIT4
 set ADC1_ADCSC1A_ADCH_3            	BIT3
 set ADC1_ADCSC1A_ADCH_2            	BIT2
 set ADC1_ADCSC1A_ADCH_1            	BIT1
 set ADC1_ADCSC1A_ADCH_0            	BIT0

;; ADC1_ADCSC2 Bit-Fields:
 set ADC1_ADCSC2_ADACT              	BIT7
 set ADC1_ADCSC2_ADTRG              	BIT6
 set ADC1_ADCSC2_ECC                	BIT2
 set ADC1_ADCSC2_REFSEL             	(BIT1+BIT0)
 set ADC1_ADCSC2_REFSEL_1           	BIT1
 set ADC1_ADCSC2_REFSEL_0           	BIT0

;; ADC1_ADCCFG Bit-Fields:
 set ADC1_ADCCFG_ADLPC              	BIT7
 set ADC1_ADCCFG_ADIV               	(BIT6+BIT5)
 set ADC1_ADCCFG_ADIV_1             	BIT6
 set ADC1_ADCCFG_ADIV_0             	BIT5
 set ADC1_ADCCFG_ADLSMP             	BIT4
 set ADC1_ADCCFG_MODE               	(BIT3+BIT2)
 set ADC1_ADCCFG_MODE_1             	BIT3
 set ADC1_ADCCFG_MODE_0             	BIT2
 set ADC1_ADCCFG_ADICLK             	(BIT1+BIT0)
 set ADC1_ADCCFG_ADICLK_1           	BIT1
 set ADC1_ADCCFG_ADICLK_0           	BIT0

;; ADC1_ADCSC1B Bit-Fields:
 set ADC1_ADCSC1B_COCO              	BIT7
 set ADC1_ADCSC1B_AIEN              	BIT6
 set ADC1_ADCSC1B_ADCO              	BIT5
 set ADC1_ADCSC1B_ADCH              	(BIT4+BIT3+BIT2+BIT1+BIT0)
 set ADC1_ADCSC1B_ADCH_4            	BIT4
 set ADC1_ADCSC1B_ADCH_3            	BIT3
 set ADC1_ADCSC1B_ADCH_2            	BIT2
 set ADC1_ADCSC1B_ADCH_1            	BIT1
 set ADC1_ADCSC1B_ADCH_0            	BIT0

;; ADC1_ADCRA Bit-Fields:
 set ADC1_ADCRA_ADR11               	BIT14
 set ADC1_ADCRA_ADR10               	BIT13
 set ADC1_ADCRA_ADR9                	BIT12
 set ADC1_ADCRA_ADR8                	BIT11
 set ADC1_ADCRA_ADR7                	BIT10
 set ADC1_ADCRA_ADR6                	BIT9
 set ADC1_ADCRA_ADR5                	BIT8
 set ADC1_ADCRA_ADR4                	BIT7
 set ADC1_ADCRA_ADR3                	BIT6
 set ADC1_ADCRA_ADR2                	BIT5
 set ADC1_ADCRA_ADR1                	BIT4
 set ADC1_ADCRA_ADR0                	BIT3

;; ADC1_ADCRB Bit-Fields:
 set ADC1_ADCRB_ADR11               	BIT14
 set ADC1_ADCRB_ADR10               	BIT13
 set ADC1_ADCRB_ADR9                	BIT12
 set ADC1_ADCRB_ADR8                	BIT11
 set ADC1_ADCRB_ADR7                	BIT10
 set ADC1_ADCRB_ADR6                	BIT9
 set ADC1_ADCRB_ADR5                	BIT8
 set ADC1_ADCRB_ADR4                	BIT7
 set ADC1_ADCRB_ADR3                	BIT6
 set ADC1_ADCRB_ADR2                	BIT5
 set ADC1_ADCRB_ADR1                	BIT4
 set ADC1_ADCRB_ADR0                	BIT3

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; PGA0 Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; PGA0_CNTL0 Bit-Fields:
 set PGA0_CNTL0_TM                  	BIT7
 set PGA0_CNTL0_GAINSEL             	(BIT6+BIT5+BIT4+BIT3+BIT2)
 set PGA0_CNTL0_GAINSEL_4           	BIT6
 set PGA0_CNTL0_GAINSEL_3           	BIT5
 set PGA0_CNTL0_GAINSEL_2           	BIT4
 set PGA0_CNTL0_GAINSEL_1           	BIT3
 set PGA0_CNTL0_GAINSEL_0           	BIT2
 set PGA0_CNTL0_LP                  	BIT1
 set PGA0_CNTL0_EN                  	BIT0

;; PGA0_CNTL1 Bit-Fields:
 set PGA0_CNTL1_BP                  	BIT5
 set PGA0_CNTL1_CALMODE             	(BIT4+BIT3)
 set PGA0_CNTL1_CALMODE_1           	BIT4
 set PGA0_CNTL1_CALMODE_0           	BIT3
 set PGA0_CNTL1_CPD                 	(BIT2+BIT1+BIT0)
 set PGA0_CNTL1_CPD_2               	BIT2
 set PGA0_CNTL1_CPD_1               	BIT1
 set PGA0_CNTL1_CPD_0               	BIT0

;; PGA0_CNTL2 Bit-Fields:
 set PGA0_CNTL2_SWTRIG              	BIT5
 set PGA0_CNTL2_NUM_CLK_GS          	(BIT4+BIT3+BIT2)
 set PGA0_CNTL2_NUM_CLK_GS_2        	BIT4
 set PGA0_CNTL2_NUM_CLK_GS_1        	BIT3
 set PGA0_CNTL2_NUM_CLK_GS_0        	BIT2
 set PGA0_CNTL2_ADIV                	(BIT1+BIT0)
 set PGA0_CNTL2_ADIV_1              	BIT1
 set PGA0_CNTL2_ADIV_0              	BIT0

;; PGA0_STS Bit-Fields:
 set PGA0_STS_RUNNING               	BIT1
 set PGA0_STS_STCOMP                	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; PGA1 Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; PGA1_CNTL0 Bit-Fields:
 set PGA1_CNTL0_TM                  	BIT7
 set PGA1_CNTL0_GAINSEL             	(BIT6+BIT5+BIT4+BIT3+BIT2)
 set PGA1_CNTL0_GAINSEL_4           	BIT6
 set PGA1_CNTL0_GAINSEL_3           	BIT5
 set PGA1_CNTL0_GAINSEL_2           	BIT4
 set PGA1_CNTL0_GAINSEL_1           	BIT3
 set PGA1_CNTL0_GAINSEL_0           	BIT2
 set PGA1_CNTL0_LP                  	BIT1
 set PGA1_CNTL0_EN                  	BIT0

;; PGA1_CNTL1 Bit-Fields:
 set PGA1_CNTL1_BP                  	BIT5
 set PGA1_CNTL1_CALMODE             	(BIT4+BIT3)
 set PGA1_CNTL1_CALMODE_1           	BIT4
 set PGA1_CNTL1_CALMODE_0           	BIT3
 set PGA1_CNTL1_CPD                 	(BIT2+BIT1+BIT0)
 set PGA1_CNTL1_CPD_2               	BIT2
 set PGA1_CNTL1_CPD_1               	BIT1
 set PGA1_CNTL1_CPD_0               	BIT0

;; PGA1_CNTL2 Bit-Fields:
 set PGA1_CNTL2_SWTRIG              	BIT5
 set PGA1_CNTL2_NUM_CLK_GS          	(BIT4+BIT3+BIT2)
 set PGA1_CNTL2_NUM_CLK_GS_2        	BIT4
 set PGA1_CNTL2_NUM_CLK_GS_1        	BIT3
 set PGA1_CNTL2_NUM_CLK_GS_0        	BIT2
 set PGA1_CNTL2_ADIV                	(BIT1+BIT0)
 set PGA1_CNTL2_ADIV_1              	BIT1
 set PGA1_CNTL2_ADIV_0              	BIT0

;; PGA1_STS Bit-Fields:
 set PGA1_STS_RUNNING               	BIT1
 set PGA1_STS_STCOMP                	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SCI Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; SCI_RATE Bit-Fields:
 set SCI_RATE_SBR                   	(BIT15+BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3)
 set SCI_RATE_SBR_12                	BIT15
 set SCI_RATE_SBR_11                	BIT14
 set SCI_RATE_SBR_10                	BIT13
 set SCI_RATE_SBR_9                 	BIT12
 set SCI_RATE_SBR_8                 	BIT11
 set SCI_RATE_SBR_7                 	BIT10
 set SCI_RATE_SBR_6                 	BIT9
 set SCI_RATE_SBR_5                 	BIT8
 set SCI_RATE_SBR_4                 	BIT7
 set SCI_RATE_SBR_3                 	BIT6
 set SCI_RATE_SBR_2                 	BIT5
 set SCI_RATE_SBR_1                 	BIT4
 set SCI_RATE_SBR_0                 	BIT3
 set SCI_RATE_FRAC_SBR              	(BIT2+BIT1+BIT0)
 set SCI_RATE_FRAC_SBR_2            	BIT2
 set SCI_RATE_FRAC_SBR_1            	BIT1
 set SCI_RATE_FRAC_SBR_0            	BIT0

;; SCI_CTRL1 Bit-Fields:
 set SCI_CTRL1_LOOP                 	BIT15
 set SCI_CTRL1_SWAI                 	BIT14
 set SCI_CTRL1_RSRC                 	BIT13
 set SCI_CTRL1_M                    	BIT12
 set SCI_CTRL1_WAKE                 	BIT11
 set SCI_CTRL1_POL                  	BIT10
 set SCI_CTRL1_PE                   	BIT9
 set SCI_CTRL1_PT                   	BIT8
 set SCI_CTRL1_TEIE                 	BIT7
 set SCI_CTRL1_TIIE                 	BIT6
 set SCI_CTRL1_RFIE                 	BIT5
 set SCI_CTRL1_REIE                 	BIT4
 set SCI_CTRL1_TE                   	BIT3
 set SCI_CTRL1_RE                   	BIT2
 set SCI_CTRL1_RWU                  	BIT1
 set SCI_CTRL1_SBK                  	BIT0

;; SCI_CTRL2 Bit-Fields:
 set SCI_CTRL2_TFCNT                	(BIT15+BIT14+BIT13)
 set SCI_CTRL2_TFCNT_2              	BIT15
 set SCI_CTRL2_TFCNT_1              	BIT14
 set SCI_CTRL2_TFCNT_0              	BIT13
 set SCI_CTRL2_TFWM                 	(BIT12+BIT11)
 set SCI_CTRL2_TFWM_1               	BIT12
 set SCI_CTRL2_TFWM_0               	BIT11
 set SCI_CTRL2_RFCNT                	(BIT10+BIT9+BIT8)
 set SCI_CTRL2_RFCNT_2              	BIT10
 set SCI_CTRL2_RFCNT_1              	BIT9
 set SCI_CTRL2_RFCNT_0              	BIT8
 set SCI_CTRL2_RFWM                 	(BIT7+BIT6)
 set SCI_CTRL2_RFWM_1               	BIT7
 set SCI_CTRL2_RFWM_0               	BIT6
 set SCI_CTRL2_FIFO_EN              	BIT5
 set SCI_CTRL2_LIN_MODE             	BIT3
 set SCI_CTRL2_RIIE                 	BIT2
 set SCI_CTRL2_TDE                  	BIT1
 set SCI_CTRL2_RDE                  	BIT0

;; SCI_STAT Bit-Fields:
 set SCI_STAT_TDRE                  	BIT15
 set SCI_STAT_TIDLE                 	BIT14
 set SCI_STAT_RDRF                  	BIT13
 set SCI_STAT_RIDLE                 	BIT12
 set SCI_STAT_OR                    	BIT11
 set SCI_STAT_NF                    	BIT10
 set SCI_STAT_FE                    	BIT9
 set SCI_STAT_PF                    	BIT8
 set SCI_STAT_LSE                   	BIT3
 set SCI_STAT_TDMA                  	BIT2
 set SCI_STAT_RDMA                  	BIT1
 set SCI_STAT_RAF                   	BIT0

;; SCI_DATA Bit-Fields:
 set SCI_DATA_Receive_Transmit_Data 	(BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set SCI_DATA_Receive_Transmit_Data_9 	BIT9
 set SCI_DATA_Receive_Transmit_Data_8 	BIT8
 set SCI_DATA_Receive_Transmit_Data_7 	BIT7
 set SCI_DATA_Receive_Transmit_Data_6 	BIT6
 set SCI_DATA_Receive_Transmit_Data_5 	BIT5
 set SCI_DATA_Receive_Transmit_Data_4 	BIT4
 set SCI_DATA_Receive_Transmit_Data_3 	BIT3
 set SCI_DATA_Receive_Transmit_Data_2 	BIT2
 set SCI_DATA_Receive_Transmit_Data_1 	BIT1
 set SCI_DATA_Receive_Transmit_Data_0 	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SPI Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; SPI_SCTRL Bit-Fields:
 set SPI_SCTRL_SPR                  	(BIT15+BIT14+BIT13)
 set SPI_SCTRL_SPR_2                	BIT15
 set SPI_SCTRL_SPR_1                	BIT14
 set SPI_SCTRL_SPR_0                	BIT13
 set SPI_SCTRL_DSO                  	BIT12
 set SPI_SCTRL_EERIE                	BIT11
 set SPI_SCTRL_MODFEN               	BIT10
 set SPI_SCTRL_SPRIE                	BIT9
 set SPI_SCTRL_SPMSTR               	BIT8
 set SPI_SCTRL_CPOL                 	BIT7
 set SPI_SCTRL_CPHA                 	BIT6
 set SPI_SCTRL_SPE                  	BIT5
 set SPI_SCTRL_SPTIE                	BIT4
 set SPI_SCTRL_SPRF                 	BIT3
 set SPI_SCTRL_OVRF                 	BIT2
 set SPI_SCTRL_MODF                 	BIT1
 set SPI_SCTRL_SPTE                 	BIT0

;; SPI_DSCTRL Bit-Fields:
 set SPI_DSCTRL_WOM                 	BIT15
 set SPI_DSCTRL_TDMAEN              	BIT14
 set SPI_DSCTRL_RDMAEN              	BIT13
 set SPI_DSCTRL_BD2X                	BIT12
 set SPI_DSCTRL_SSB_IN              	BIT11
 set SPI_DSCTRL_SSB_DATA            	BIT10
 set SPI_DSCTRL_SSB_ODM             	BIT9
 set SPI_DSCTRL_SSB_AUTO            	BIT8
 set SPI_DSCTRL_SSB_DDR             	BIT7
 set SPI_DSCTRL_SSB_STRB            	BIT6
 set SPI_DSCTRL_SSB_OVER            	BIT5
 set SPI_DSCTRL_DS                  	(BIT3+BIT2+BIT1+BIT0)
 set SPI_DSCTRL_DS_3                	BIT3
 set SPI_DSCTRL_DS_2                	BIT2
 set SPI_DSCTRL_DS_1                	BIT1
 set SPI_DSCTRL_DS_0                	BIT0

;; SPI_DRCV Bit-Fields:
 set SPI_DRCV_R15                   	BIT15
 set SPI_DRCV_R14                   	BIT14
 set SPI_DRCV_R13                   	BIT13
 set SPI_DRCV_R12                   	BIT12
 set SPI_DRCV_R11                   	BIT11
 set SPI_DRCV_R10                   	BIT10
 set SPI_DRCV_R9                    	BIT9
 set SPI_DRCV_R8                    	BIT8
 set SPI_DRCV_R7                    	BIT7
 set SPI_DRCV_R6                    	BIT6
 set SPI_DRCV_R5                    	BIT5
 set SPI_DRCV_R4                    	BIT4
 set SPI_DRCV_R3                    	BIT3
 set SPI_DRCV_R2                    	BIT2
 set SPI_DRCV_R1                    	BIT1
 set SPI_DRCV_R0                    	BIT0

;; SPI_DXMIT Bit-Fields:
 set SPI_DXMIT_T15                  	BIT15
 set SPI_DXMIT_T14                  	BIT14
 set SPI_DXMIT_T13                  	BIT13
 set SPI_DXMIT_T12                  	BIT12
 set SPI_DXMIT_T11                  	BIT11
 set SPI_DXMIT_T10                  	BIT10
 set SPI_DXMIT_T9                   	BIT9
 set SPI_DXMIT_T8                   	BIT8
 set SPI_DXMIT_T7                   	BIT7
 set SPI_DXMIT_T6                   	BIT6
 set SPI_DXMIT_T5                   	BIT5
 set SPI_DXMIT_T4                   	BIT4
 set SPI_DXMIT_T3                   	BIT3
 set SPI_DXMIT_T2                   	BIT2
 set SPI_DXMIT_T1                   	BIT1
 set SPI_DXMIT_T0                   	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; I2C Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; I2C_ADDR Bit-Fields:
 set I2C_ADDR_AD7                   	BIT7
 set I2C_ADDR_AD6                   	BIT6
 set I2C_ADDR_AD5                   	BIT5
 set I2C_ADDR_AD4                   	BIT4
 set I2C_ADDR_AD3                   	BIT3
 set I2C_ADDR_AD2                   	BIT2
 set I2C_ADDR_AD1                   	BIT1

;; I2C_FREQDIV Bit-Fields:
 set I2C_FREQDIV_MULT               	(BIT7+BIT6)
 set I2C_FREQDIV_MULT_1             	BIT7
 set I2C_FREQDIV_MULT_0             	BIT6
 set I2C_FREQDIV_ICR                	(BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set I2C_FREQDIV_ICR_5              	BIT5
 set I2C_FREQDIV_ICR_4              	BIT4
 set I2C_FREQDIV_ICR_3              	BIT3
 set I2C_FREQDIV_ICR_2              	BIT2
 set I2C_FREQDIV_ICR_1              	BIT1
 set I2C_FREQDIV_ICR_0              	BIT0

;; I2C_CR1 Bit-Fields:
 set I2C_CR1_IICEN                  	BIT7
 set I2C_CR1_IICIE                  	BIT6
 set I2C_CR1_MST                    	BIT5
 set I2C_CR1_TX                     	BIT4
 set I2C_CR1_TXAK                   	BIT3
 set I2C_CR1_RSTA                   	BIT2

;; I2C_SR Bit-Fields:
 set I2C_SR_TCF                     	BIT7
 set I2C_SR_IAAS                    	BIT6
 set I2C_SR_BUSY                    	BIT5
 set I2C_SR_ARBL                    	BIT4
 set I2C_SR_SRW                     	BIT2
 set I2C_SR_IICIF                   	BIT1
 set I2C_SR_RXAK                    	BIT0

;; I2C_DATA Bit-Fields:
 set I2C_DATA_DATA                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set I2C_DATA_DATA_7                	BIT7
 set I2C_DATA_DATA_6                	BIT6
 set I2C_DATA_DATA_5                	BIT5
 set I2C_DATA_DATA_4                	BIT4
 set I2C_DATA_DATA_3                	BIT3
 set I2C_DATA_DATA_2                	BIT2
 set I2C_DATA_DATA_1                	BIT1
 set I2C_DATA_DATA_0                	BIT0

;; I2C_CR2 Bit-Fields:
 set I2C_CR2_GCAEN                  	BIT7
 set I2C_CR2_ADEXT                  	BIT6
 set I2C_CR2_AD10                   	BIT2
 set I2C_CR2_AD9                    	BIT1
 set I2C_CR2_AD8                    	BIT0

;; I2C_SMB_CSR Bit-Fields:
 set I2C_SMB_CSR_FACK               	BIT7
 set I2C_SMB_CSR_ALERTEN            	BIT6
 set I2C_SMB_CSR_SIICAEN            	BIT5
 set I2C_SMB_CSR_TCKSEL             	BIT4
 set I2C_SMB_CSR_SLTF               	BIT3
 set I2C_SMB_CSR_SHTF               	BIT2

;; I2C_ADDR2 Bit-Fields:
 set I2C_ADDR2_SAD7                 	BIT7
 set I2C_ADDR2_SAD6                 	BIT6
 set I2C_ADDR2_SAD5                 	BIT5
 set I2C_ADDR2_SAD4                 	BIT4
 set I2C_ADDR2_SAD3                 	BIT3
 set I2C_ADDR2_SAD2                 	BIT2
 set I2C_ADDR2_SAD1                 	BIT1

;; I2C_SLT1 Bit-Fields:
 set I2C_SLT1_SSLT7                 	BIT7
 set I2C_SLT1_SSLT6                 	BIT6
 set I2C_SLT1_SSLT5                 	BIT5
 set I2C_SLT1_SSLT4                 	BIT4
 set I2C_SLT1_SSLT3                 	BIT3
 set I2C_SLT1_SSLT2                 	BIT2
 set I2C_SLT1_SSLT1                 	BIT1
 set I2C_SLT1_SSLT0                 	BIT0

;; I2C_SLT2 Bit-Fields:
 set I2C_SLT2_SSLT15                	BIT7
 set I2C_SLT2_SSLT14                	BIT6
 set I2C_SLT2_SSLT13                	BIT5
 set I2C_SLT2_SSLT12                	BIT4
 set I2C_SLT2_SSLT11                	BIT3
 set I2C_SLT2_SSLT10                	BIT2
 set I2C_SLT2_SSLT9                 	BIT1
 set I2C_SLT2_SSLT8                 	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; COP Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; COP_CTRL Bit-Fields:
 set COP_CTRL_PSS                   	(BIT9+BIT8)
 set COP_CTRL_PSS_1                 	BIT9
 set COP_CTRL_PSS_0                 	BIT8
 set COP_CTRL_CLKSEL                	(BIT6+BIT5)
 set COP_CTRL_CLKSEL_1              	BIT6
 set COP_CTRL_CLKSEL_0              	BIT5
 set COP_CTRL_CLOREN                	BIT4
 set COP_CTRL_CSEN                  	BIT3
 set COP_CTRL_CWEN                  	BIT2
 set COP_CTRL_CEN                   	BIT1
 set COP_CTRL_CWP                   	BIT0

;; COP_TOUT Bit-Fields:
 set COP_TOUT_TIMEOUT               	$FFFF

;; COP_CNTR Bit-Fields:
 set COP_CNTR_COUNT_SERVICE         	$FFFF

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; OCCS Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; OCCS_CTRL Bit-Fields:
 set OCCS_CTRL_PLLIE1               	(BIT15+BIT14)
 set OCCS_CTRL_PLLIE1_1             	BIT15
 set OCCS_CTRL_PLLIE1_0             	BIT14
 set OCCS_CTRL_PLLIE0               	(BIT13+BIT12)
 set OCCS_CTRL_PLLIE0_1             	BIT13
 set OCCS_CTRL_PLLIE0_0             	BIT12
 set OCCS_CTRL_LOCIE                	BIT11
 set OCCS_CTRL_LCKON                	BIT7
 set OCCS_CTRL_PLLPD                	BIT4
 set OCCS_CTRL_PRECS                	BIT2
 set OCCS_CTRL_ZSRC                 	(BIT1+BIT0)
 set OCCS_CTRL_ZSRC_1               	BIT1
 set OCCS_CTRL_ZSRC_0               	BIT0

;; OCCS_DIVBY Bit-Fields:
 set OCCS_DIVBY_LORTP               	(BIT15+BIT14+BIT13+BIT12)
 set OCCS_DIVBY_LORTP_3             	BIT15
 set OCCS_DIVBY_LORTP_2             	BIT14
 set OCCS_DIVBY_LORTP_1             	BIT13
 set OCCS_DIVBY_LORTP_0             	BIT12
 set OCCS_DIVBY_COD                 	(BIT11+BIT10+BIT9+BIT8)
 set OCCS_DIVBY_COD_3               	BIT11
 set OCCS_DIVBY_COD_2               	BIT10
 set OCCS_DIVBY_COD_1               	BIT9
 set OCCS_DIVBY_COD_0               	BIT8

;; OCCS_STAT Bit-Fields:
 set OCCS_STAT_LOLI1                	BIT15
 set OCCS_STAT_LOLI0                	BIT14
 set OCCS_STAT_LOCI                 	BIT13
 set OCCS_STAT_LCK1                 	BIT6
 set OCCS_STAT_LCK0                 	BIT5
 set OCCS_STAT_PLLPDN               	BIT4
 set OCCS_STAT_COSC_RDY             	BIT2
 set OCCS_STAT_ZSRCS                	(BIT1+BIT0)
 set OCCS_STAT_ZSRCS_1              	BIT1
 set OCCS_STAT_ZSRCS_0              	BIT0

;; OCCS_TESTR Bit-Fields:
 set OCCS_TESTR_TPLLREF             	BIT7
 set OCCS_TESTR_TFDBK               	BIT5
 set OCCS_TESTR_TFREF               	BIT4
 set OCCS_TESTR_FLOCI               	BIT3
 set OCCS_TESTR_FLOLI1              	BIT2
 set OCCS_TESTR_FLOLI0              	BIT1
 set OCCS_TESTR_TM                  	BIT0

;; OCCS_OCTRL Bit-Fields:
 set OCCS_OCTRL_ROPD                	BIT15
 set OCCS_OCTRL_ROSB                	BIT14
 set OCCS_OCTRL_COHL                	BIT13
 set OCCS_OCTRL_CLK_MODE            	BIT12
 set OCCS_OCTRL_RANGE               	BIT11
 set OCCS_OCTRL_EXT_SEL             	BIT10
 set OCCS_OCTRL_TRIM                	(BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set OCCS_OCTRL_TRIM_9              	BIT9
 set OCCS_OCTRL_TRIM_8              	BIT8
 set OCCS_OCTRL_TRIM_7              	BIT7
 set OCCS_OCTRL_TRIM_6              	BIT6
 set OCCS_OCTRL_TRIM_5              	BIT5
 set OCCS_OCTRL_TRIM_4              	BIT4
 set OCCS_OCTRL_TRIM_3              	BIT3
 set OCCS_OCTRL_TRIM_2              	BIT2
 set OCCS_OCTRL_TRIM_1              	BIT1
 set OCCS_OCTRL_TRIM_0              	BIT0

;; OCCS_CLKCHKR Bit-Fields:
 set OCCS_CLKCHKR_CHK_ENA           	BIT15
 set OCCS_CLKCHKR_REFERENCE_CNT     	(BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set OCCS_CLKCHKR_REFERENCE_CNT_14  	BIT14
 set OCCS_CLKCHKR_REFERENCE_CNT_13  	BIT13
 set OCCS_CLKCHKR_REFERENCE_CNT_12  	BIT12
 set OCCS_CLKCHKR_REFERENCE_CNT_11  	BIT11
 set OCCS_CLKCHKR_REFERENCE_CNT_10  	BIT10
 set OCCS_CLKCHKR_REFERENCE_CNT_9   	BIT9
 set OCCS_CLKCHKR_REFERENCE_CNT_8   	BIT8
 set OCCS_CLKCHKR_REFERENCE_CNT_7   	BIT7
 set OCCS_CLKCHKR_REFERENCE_CNT_6   	BIT6
 set OCCS_CLKCHKR_REFERENCE_CNT_5   	BIT5
 set OCCS_CLKCHKR_REFERENCE_CNT_4   	BIT4
 set OCCS_CLKCHKR_REFERENCE_CNT_3   	BIT3
 set OCCS_CLKCHKR_REFERENCE_CNT_2   	BIT2
 set OCCS_CLKCHKR_REFERENCE_CNT_1   	BIT1
 set OCCS_CLKCHKR_REFERENCE_CNT_0   	BIT0

;; OCCS_CLKCHKT Bit-Fields:
 set OCCS_CLKCHKT_TARGET_CNT        	(BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set OCCS_CLKCHKT_TARGET_CNT_6      	BIT6
 set OCCS_CLKCHKT_TARGET_CNT_5      	BIT5
 set OCCS_CLKCHKT_TARGET_CNT_4      	BIT4
 set OCCS_CLKCHKT_TARGET_CNT_3      	BIT3
 set OCCS_CLKCHKT_TARGET_CNT_2      	BIT2
 set OCCS_CLKCHKT_TARGET_CNT_1      	BIT1
 set OCCS_CLKCHKT_TARGET_CNT_0      	BIT0

;; OCCS_PROT Bit-Fields:
 set OCCS_PROT_FRQEP                	(BIT5+BIT4)
 set OCCS_PROT_FRQEP_1              	BIT5
 set OCCS_PROT_FRQEP_0              	BIT4
 set OCCS_PROT_OSCEP                	(BIT3+BIT2)
 set OCCS_PROT_OSCEP_1              	BIT3
 set OCCS_PROT_OSCEP_0              	BIT2
 set OCCS_PROT_PLLEP                	(BIT1+BIT0)
 set OCCS_PROT_PLLEP_1              	BIT1
 set OCCS_PROT_PLLEP_0              	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; GPIOA Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; GPIOA_PUR Bit-Fields:
 set GPIOA_PUR_PUR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOA_PUR_PUR_7                	BIT7
 set GPIOA_PUR_PUR_6                	BIT6
 set GPIOA_PUR_PUR_5                	BIT5
 set GPIOA_PUR_PUR_4                	BIT4
 set GPIOA_PUR_PUR_3                	BIT3
 set GPIOA_PUR_PUR_2                	BIT2
 set GPIOA_PUR_PUR_1                	BIT1
 set GPIOA_PUR_PUR_0                	BIT0

;; GPIOA_DR Bit-Fields:
 set GPIOA_DR_DR                    	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOA_DR_DR_7                  	BIT7
 set GPIOA_DR_DR_6                  	BIT6
 set GPIOA_DR_DR_5                  	BIT5
 set GPIOA_DR_DR_4                  	BIT4
 set GPIOA_DR_DR_3                  	BIT3
 set GPIOA_DR_DR_2                  	BIT2
 set GPIOA_DR_DR_1                  	BIT1
 set GPIOA_DR_DR_0                  	BIT0

;; GPIOA_DDR Bit-Fields:
 set GPIOA_DDR_DDR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOA_DDR_DDR_7                	BIT7
 set GPIOA_DDR_DDR_6                	BIT6
 set GPIOA_DDR_DDR_5                	BIT5
 set GPIOA_DDR_DDR_4                	BIT4
 set GPIOA_DDR_DDR_3                	BIT3
 set GPIOA_DDR_DDR_2                	BIT2
 set GPIOA_DDR_DDR_1                	BIT1
 set GPIOA_DDR_DDR_0                	BIT0

;; GPIOA_PER Bit-Fields:
 set GPIOA_PER_PER                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOA_PER_PER_7                	BIT7
 set GPIOA_PER_PER_6                	BIT6
 set GPIOA_PER_PER_5                	BIT5
 set GPIOA_PER_PER_4                	BIT4
 set GPIOA_PER_PER_3                	BIT3
 set GPIOA_PER_PER_2                	BIT2
 set GPIOA_PER_PER_1                	BIT1
 set GPIOA_PER_PER_0                	BIT0

;; GPIOA_IENR Bit-Fields:
 set GPIOA_IENR_IENR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOA_IENR_IENR_7              	BIT7
 set GPIOA_IENR_IENR_6              	BIT6
 set GPIOA_IENR_IENR_5              	BIT5
 set GPIOA_IENR_IENR_4              	BIT4
 set GPIOA_IENR_IENR_3              	BIT3
 set GPIOA_IENR_IENR_2              	BIT2
 set GPIOA_IENR_IENR_1              	BIT1
 set GPIOA_IENR_IENR_0              	BIT0

;; GPIOA_IPOLR Bit-Fields:
 set GPIOA_IPOLR_IPOLR              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOA_IPOLR_IPOLR_7            	BIT7
 set GPIOA_IPOLR_IPOLR_6            	BIT6
 set GPIOA_IPOLR_IPOLR_5            	BIT5
 set GPIOA_IPOLR_IPOLR_4            	BIT4
 set GPIOA_IPOLR_IPOLR_3            	BIT3
 set GPIOA_IPOLR_IPOLR_2            	BIT2
 set GPIOA_IPOLR_IPOLR_1            	BIT1
 set GPIOA_IPOLR_IPOLR_0            	BIT0

;; GPIOA_IPR Bit-Fields:
 set GPIOA_IPR_IPR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOA_IPR_IPR_7                	BIT7
 set GPIOA_IPR_IPR_6                	BIT6
 set GPIOA_IPR_IPR_5                	BIT5
 set GPIOA_IPR_IPR_4                	BIT4
 set GPIOA_IPR_IPR_3                	BIT3
 set GPIOA_IPR_IPR_2                	BIT2
 set GPIOA_IPR_IPR_1                	BIT1
 set GPIOA_IPR_IPR_0                	BIT0

;; GPIOA_IESR Bit-Fields:
 set GPIOA_IESR_IESR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOA_IESR_IESR_7              	BIT7
 set GPIOA_IESR_IESR_6              	BIT6
 set GPIOA_IESR_IESR_5              	BIT5
 set GPIOA_IESR_IESR_4              	BIT4
 set GPIOA_IESR_IESR_3              	BIT3
 set GPIOA_IESR_IESR_2              	BIT2
 set GPIOA_IESR_IESR_1              	BIT1
 set GPIOA_IESR_IESR_0              	BIT0

;; GPIOA_RAWDATA Bit-Fields:
 set GPIOA_RAWDATA_RAWDATA          	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOA_RAWDATA_RAWDATA_7        	BIT7
 set GPIOA_RAWDATA_RAWDATA_6        	BIT6
 set GPIOA_RAWDATA_RAWDATA_5        	BIT5
 set GPIOA_RAWDATA_RAWDATA_4        	BIT4
 set GPIOA_RAWDATA_RAWDATA_3        	BIT3
 set GPIOA_RAWDATA_RAWDATA_2        	BIT2
 set GPIOA_RAWDATA_RAWDATA_1        	BIT1
 set GPIOA_RAWDATA_RAWDATA_0        	BIT0

;; GPIOA_DRIVE Bit-Fields:
 set GPIOA_DRIVE_DRIVE              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOA_DRIVE_DRIVE_7            	BIT7
 set GPIOA_DRIVE_DRIVE_6            	BIT6
 set GPIOA_DRIVE_DRIVE_5            	BIT5
 set GPIOA_DRIVE_DRIVE_4            	BIT4
 set GPIOA_DRIVE_DRIVE_3            	BIT3
 set GPIOA_DRIVE_DRIVE_2            	BIT2
 set GPIOA_DRIVE_DRIVE_1            	BIT1
 set GPIOA_DRIVE_DRIVE_0            	BIT0

;; GPIOA_IFE Bit-Fields:
 set GPIOA_IFE_IFE                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOA_IFE_IFE_7                	BIT7
 set GPIOA_IFE_IFE_6                	BIT6
 set GPIOA_IFE_IFE_5                	BIT5
 set GPIOA_IFE_IFE_4                	BIT4
 set GPIOA_IFE_IFE_3                	BIT3
 set GPIOA_IFE_IFE_2                	BIT2
 set GPIOA_IFE_IFE_1                	BIT1
 set GPIOA_IFE_IFE_0                	BIT0

;; GPIOA_SLEW Bit-Fields:
 set GPIOA_SLEW_SLEW                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOA_SLEW_SLEW_7              	BIT7
 set GPIOA_SLEW_SLEW_6              	BIT6
 set GPIOA_SLEW_SLEW_5              	BIT5
 set GPIOA_SLEW_SLEW_4              	BIT4
 set GPIOA_SLEW_SLEW_3              	BIT3
 set GPIOA_SLEW_SLEW_2              	BIT2
 set GPIOA_SLEW_SLEW_1              	BIT1
 set GPIOA_SLEW_SLEW_0              	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; GPIOB Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; GPIOB_PUR Bit-Fields:
 set GPIOB_PUR_PUR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOB_PUR_PUR_7                	BIT7
 set GPIOB_PUR_PUR_6                	BIT6
 set GPIOB_PUR_PUR_5                	BIT5
 set GPIOB_PUR_PUR_4                	BIT4
 set GPIOB_PUR_PUR_3                	BIT3
 set GPIOB_PUR_PUR_2                	BIT2
 set GPIOB_PUR_PUR_1                	BIT1
 set GPIOB_PUR_PUR_0                	BIT0

;; GPIOB_DR Bit-Fields:
 set GPIOB_DR_DR                    	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOB_DR_DR_7                  	BIT7
 set GPIOB_DR_DR_6                  	BIT6
 set GPIOB_DR_DR_5                  	BIT5
 set GPIOB_DR_DR_4                  	BIT4
 set GPIOB_DR_DR_3                  	BIT3
 set GPIOB_DR_DR_2                  	BIT2
 set GPIOB_DR_DR_1                  	BIT1
 set GPIOB_DR_DR_0                  	BIT0

;; GPIOB_DDR Bit-Fields:
 set GPIOB_DDR_DDR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOB_DDR_DDR_7                	BIT7
 set GPIOB_DDR_DDR_6                	BIT6
 set GPIOB_DDR_DDR_5                	BIT5
 set GPIOB_DDR_DDR_4                	BIT4
 set GPIOB_DDR_DDR_3                	BIT3
 set GPIOB_DDR_DDR_2                	BIT2
 set GPIOB_DDR_DDR_1                	BIT1
 set GPIOB_DDR_DDR_0                	BIT0

;; GPIOB_PER Bit-Fields:
 set GPIOB_PER_PER                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOB_PER_PER_7                	BIT7
 set GPIOB_PER_PER_6                	BIT6
 set GPIOB_PER_PER_5                	BIT5
 set GPIOB_PER_PER_4                	BIT4
 set GPIOB_PER_PER_3                	BIT3
 set GPIOB_PER_PER_2                	BIT2
 set GPIOB_PER_PER_1                	BIT1
 set GPIOB_PER_PER_0                	BIT0

;; GPIOB_IENR Bit-Fields:
 set GPIOB_IENR_IENR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOB_IENR_IENR_7              	BIT7
 set GPIOB_IENR_IENR_6              	BIT6
 set GPIOB_IENR_IENR_5              	BIT5
 set GPIOB_IENR_IENR_4              	BIT4
 set GPIOB_IENR_IENR_3              	BIT3
 set GPIOB_IENR_IENR_2              	BIT2
 set GPIOB_IENR_IENR_1              	BIT1
 set GPIOB_IENR_IENR_0              	BIT0

;; GPIOB_IPOLR Bit-Fields:
 set GPIOB_IPOLR_IPOLR              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOB_IPOLR_IPOLR_7            	BIT7
 set GPIOB_IPOLR_IPOLR_6            	BIT6
 set GPIOB_IPOLR_IPOLR_5            	BIT5
 set GPIOB_IPOLR_IPOLR_4            	BIT4
 set GPIOB_IPOLR_IPOLR_3            	BIT3
 set GPIOB_IPOLR_IPOLR_2            	BIT2
 set GPIOB_IPOLR_IPOLR_1            	BIT1
 set GPIOB_IPOLR_IPOLR_0            	BIT0

;; GPIOB_IPR Bit-Fields:
 set GPIOB_IPR_IPR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOB_IPR_IPR_7                	BIT7
 set GPIOB_IPR_IPR_6                	BIT6
 set GPIOB_IPR_IPR_5                	BIT5
 set GPIOB_IPR_IPR_4                	BIT4
 set GPIOB_IPR_IPR_3                	BIT3
 set GPIOB_IPR_IPR_2                	BIT2
 set GPIOB_IPR_IPR_1                	BIT1
 set GPIOB_IPR_IPR_0                	BIT0

;; GPIOB_IESR Bit-Fields:
 set GPIOB_IESR_IESR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOB_IESR_IESR_7              	BIT7
 set GPIOB_IESR_IESR_6              	BIT6
 set GPIOB_IESR_IESR_5              	BIT5
 set GPIOB_IESR_IESR_4              	BIT4
 set GPIOB_IESR_IESR_3              	BIT3
 set GPIOB_IESR_IESR_2              	BIT2
 set GPIOB_IESR_IESR_1              	BIT1
 set GPIOB_IESR_IESR_0              	BIT0

;; GPIOB_RAWDATA Bit-Fields:
 set GPIOB_RAWDATA_RAWDATA          	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOB_RAWDATA_RAWDATA_7        	BIT7
 set GPIOB_RAWDATA_RAWDATA_6        	BIT6
 set GPIOB_RAWDATA_RAWDATA_5        	BIT5
 set GPIOB_RAWDATA_RAWDATA_4        	BIT4
 set GPIOB_RAWDATA_RAWDATA_3        	BIT3
 set GPIOB_RAWDATA_RAWDATA_2        	BIT2
 set GPIOB_RAWDATA_RAWDATA_1        	BIT1
 set GPIOB_RAWDATA_RAWDATA_0        	BIT0

;; GPIOB_DRIVE Bit-Fields:
 set GPIOB_DRIVE_DRIVE              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOB_DRIVE_DRIVE_7            	BIT7
 set GPIOB_DRIVE_DRIVE_6            	BIT6
 set GPIOB_DRIVE_DRIVE_5            	BIT5
 set GPIOB_DRIVE_DRIVE_4            	BIT4
 set GPIOB_DRIVE_DRIVE_3            	BIT3
 set GPIOB_DRIVE_DRIVE_2            	BIT2
 set GPIOB_DRIVE_DRIVE_1            	BIT1
 set GPIOB_DRIVE_DRIVE_0            	BIT0

;; GPIOB_IFE Bit-Fields:
 set GPIOB_IFE_IFE                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOB_IFE_IFE_7                	BIT7
 set GPIOB_IFE_IFE_6                	BIT6
 set GPIOB_IFE_IFE_5                	BIT5
 set GPIOB_IFE_IFE_4                	BIT4
 set GPIOB_IFE_IFE_3                	BIT3
 set GPIOB_IFE_IFE_2                	BIT2
 set GPIOB_IFE_IFE_1                	BIT1
 set GPIOB_IFE_IFE_0                	BIT0

;; GPIOB_SLEW Bit-Fields:
 set GPIOB_SLEW_SLEW                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOB_SLEW_SLEW_7              	BIT7
 set GPIOB_SLEW_SLEW_6              	BIT6
 set GPIOB_SLEW_SLEW_5              	BIT5
 set GPIOB_SLEW_SLEW_4              	BIT4
 set GPIOB_SLEW_SLEW_3              	BIT3
 set GPIOB_SLEW_SLEW_2              	BIT2
 set GPIOB_SLEW_SLEW_1              	BIT1
 set GPIOB_SLEW_SLEW_0              	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; GPIOC Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; GPIOC_PUR Bit-Fields:
 set GPIOC_PUR_PUR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOC_PUR_PUR_7                	BIT7
 set GPIOC_PUR_PUR_6                	BIT6
 set GPIOC_PUR_PUR_5                	BIT5
 set GPIOC_PUR_PUR_4                	BIT4
 set GPIOC_PUR_PUR_3                	BIT3
 set GPIOC_PUR_PUR_2                	BIT2
 set GPIOC_PUR_PUR_1                	BIT1
 set GPIOC_PUR_PUR_0                	BIT0

;; GPIOC_DR Bit-Fields:
 set GPIOC_DR_DR                    	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOC_DR_DR_7                  	BIT7
 set GPIOC_DR_DR_6                  	BIT6
 set GPIOC_DR_DR_5                  	BIT5
 set GPIOC_DR_DR_4                  	BIT4
 set GPIOC_DR_DR_3                  	BIT3
 set GPIOC_DR_DR_2                  	BIT2
 set GPIOC_DR_DR_1                  	BIT1
 set GPIOC_DR_DR_0                  	BIT0

;; GPIOC_DDR Bit-Fields:
 set GPIOC_DDR_DDR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOC_DDR_DDR_7                	BIT7
 set GPIOC_DDR_DDR_6                	BIT6
 set GPIOC_DDR_DDR_5                	BIT5
 set GPIOC_DDR_DDR_4                	BIT4
 set GPIOC_DDR_DDR_3                	BIT3
 set GPIOC_DDR_DDR_2                	BIT2
 set GPIOC_DDR_DDR_1                	BIT1
 set GPIOC_DDR_DDR_0                	BIT0

;; GPIOC_PER Bit-Fields:
 set GPIOC_PER_PER                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOC_PER_PER_7                	BIT7
 set GPIOC_PER_PER_6                	BIT6
 set GPIOC_PER_PER_5                	BIT5
 set GPIOC_PER_PER_4                	BIT4
 set GPIOC_PER_PER_3                	BIT3
 set GPIOC_PER_PER_2                	BIT2
 set GPIOC_PER_PER_1                	BIT1
 set GPIOC_PER_PER_0                	BIT0

;; GPIOC_IENR Bit-Fields:
 set GPIOC_IENR_IENR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOC_IENR_IENR_7              	BIT7
 set GPIOC_IENR_IENR_6              	BIT6
 set GPIOC_IENR_IENR_5              	BIT5
 set GPIOC_IENR_IENR_4              	BIT4
 set GPIOC_IENR_IENR_3              	BIT3
 set GPIOC_IENR_IENR_2              	BIT2
 set GPIOC_IENR_IENR_1              	BIT1
 set GPIOC_IENR_IENR_0              	BIT0

;; GPIOC_IPOLR Bit-Fields:
 set GPIOC_IPOLR_IPOLR              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOC_IPOLR_IPOLR_7            	BIT7
 set GPIOC_IPOLR_IPOLR_6            	BIT6
 set GPIOC_IPOLR_IPOLR_5            	BIT5
 set GPIOC_IPOLR_IPOLR_4            	BIT4
 set GPIOC_IPOLR_IPOLR_3            	BIT3
 set GPIOC_IPOLR_IPOLR_2            	BIT2
 set GPIOC_IPOLR_IPOLR_1            	BIT1
 set GPIOC_IPOLR_IPOLR_0            	BIT0

;; GPIOC_IPR Bit-Fields:
 set GPIOC_IPR_IPR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOC_IPR_IPR_7                	BIT7
 set GPIOC_IPR_IPR_6                	BIT6
 set GPIOC_IPR_IPR_5                	BIT5
 set GPIOC_IPR_IPR_4                	BIT4
 set GPIOC_IPR_IPR_3                	BIT3
 set GPIOC_IPR_IPR_2                	BIT2
 set GPIOC_IPR_IPR_1                	BIT1
 set GPIOC_IPR_IPR_0                	BIT0

;; GPIOC_IESR Bit-Fields:
 set GPIOC_IESR_IESR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOC_IESR_IESR_7              	BIT7
 set GPIOC_IESR_IESR_6              	BIT6
 set GPIOC_IESR_IESR_5              	BIT5
 set GPIOC_IESR_IESR_4              	BIT4
 set GPIOC_IESR_IESR_3              	BIT3
 set GPIOC_IESR_IESR_2              	BIT2
 set GPIOC_IESR_IESR_1              	BIT1
 set GPIOC_IESR_IESR_0              	BIT0

;; GPIOC_RAWDATA Bit-Fields:
 set GPIOC_RAWDATA_RAWDATA          	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOC_RAWDATA_RAWDATA_7        	BIT7
 set GPIOC_RAWDATA_RAWDATA_6        	BIT6
 set GPIOC_RAWDATA_RAWDATA_5        	BIT5
 set GPIOC_RAWDATA_RAWDATA_4        	BIT4
 set GPIOC_RAWDATA_RAWDATA_3        	BIT3
 set GPIOC_RAWDATA_RAWDATA_2        	BIT2
 set GPIOC_RAWDATA_RAWDATA_1        	BIT1
 set GPIOC_RAWDATA_RAWDATA_0        	BIT0

;; GPIOC_DRIVE Bit-Fields:
 set GPIOC_DRIVE_DRIVE              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOC_DRIVE_DRIVE_7            	BIT7
 set GPIOC_DRIVE_DRIVE_6            	BIT6
 set GPIOC_DRIVE_DRIVE_5            	BIT5
 set GPIOC_DRIVE_DRIVE_4            	BIT4
 set GPIOC_DRIVE_DRIVE_3            	BIT3
 set GPIOC_DRIVE_DRIVE_2            	BIT2
 set GPIOC_DRIVE_DRIVE_1            	BIT1
 set GPIOC_DRIVE_DRIVE_0            	BIT0

;; GPIOC_IFE Bit-Fields:
 set GPIOC_IFE_IFE                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOC_IFE_IFE_7                	BIT7
 set GPIOC_IFE_IFE_6                	BIT6
 set GPIOC_IFE_IFE_5                	BIT5
 set GPIOC_IFE_IFE_4                	BIT4
 set GPIOC_IFE_IFE_3                	BIT3
 set GPIOC_IFE_IFE_2                	BIT2
 set GPIOC_IFE_IFE_1                	BIT1
 set GPIOC_IFE_IFE_0                	BIT0

;; GPIOC_SLEW Bit-Fields:
 set GPIOC_SLEW_SLEW                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOC_SLEW_SLEW_7              	BIT7
 set GPIOC_SLEW_SLEW_6              	BIT6
 set GPIOC_SLEW_SLEW_5              	BIT5
 set GPIOC_SLEW_SLEW_4              	BIT4
 set GPIOC_SLEW_SLEW_3              	BIT3
 set GPIOC_SLEW_SLEW_2              	BIT2
 set GPIOC_SLEW_SLEW_1              	BIT1
 set GPIOC_SLEW_SLEW_0              	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; GPIOD Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; GPIOD_PUR Bit-Fields:
 set GPIOD_PUR_PUR                  	(BIT3+BIT2+BIT1+BIT0)
 set GPIOD_PUR_PUR_3                	BIT3
 set GPIOD_PUR_PUR_2                	BIT2
 set GPIOD_PUR_PUR_1                	BIT1
 set GPIOD_PUR_PUR_0                	BIT0

;; GPIOD_DR Bit-Fields:
 set GPIOD_DR_DR                    	(BIT3+BIT2+BIT1+BIT0)
 set GPIOD_DR_DR_3                  	BIT3
 set GPIOD_DR_DR_2                  	BIT2
 set GPIOD_DR_DR_1                  	BIT1
 set GPIOD_DR_DR_0                  	BIT0

;; GPIOD_DDR Bit-Fields:
 set GPIOD_DDR_DDR                  	(BIT3+BIT2+BIT1+BIT0)
 set GPIOD_DDR_DDR_3                	BIT3
 set GPIOD_DDR_DDR_2                	BIT2
 set GPIOD_DDR_DDR_1                	BIT1
 set GPIOD_DDR_DDR_0                	BIT0

;; GPIOD_PER Bit-Fields:
 set GPIOD_PER_PER                  	(BIT3+BIT2+BIT1+BIT0)
 set GPIOD_PER_PER_3                	BIT3
 set GPIOD_PER_PER_2                	BIT2
 set GPIOD_PER_PER_1                	BIT1
 set GPIOD_PER_PER_0                	BIT0

;; GPIOD_IENR Bit-Fields:
 set GPIOD_IENR_IENR                	(BIT3+BIT2+BIT1+BIT0)
 set GPIOD_IENR_IENR_3              	BIT3
 set GPIOD_IENR_IENR_2              	BIT2
 set GPIOD_IENR_IENR_1              	BIT1
 set GPIOD_IENR_IENR_0              	BIT0

;; GPIOD_IPOLR Bit-Fields:
 set GPIOD_IPOLR_IPOLR              	(BIT3+BIT2+BIT1+BIT0)
 set GPIOD_IPOLR_IPOLR_3            	BIT3
 set GPIOD_IPOLR_IPOLR_2            	BIT2
 set GPIOD_IPOLR_IPOLR_1            	BIT1
 set GPIOD_IPOLR_IPOLR_0            	BIT0

;; GPIOD_IPR Bit-Fields:
 set GPIOD_IPR_IPR                  	(BIT3+BIT2+BIT1+BIT0)
 set GPIOD_IPR_IPR_3                	BIT3
 set GPIOD_IPR_IPR_2                	BIT2
 set GPIOD_IPR_IPR_1                	BIT1
 set GPIOD_IPR_IPR_0                	BIT0

;; GPIOD_IESR Bit-Fields:
 set GPIOD_IESR_IESR                	(BIT3+BIT2+BIT1+BIT0)
 set GPIOD_IESR_IESR_3              	BIT3
 set GPIOD_IESR_IESR_2              	BIT2
 set GPIOD_IESR_IESR_1              	BIT1
 set GPIOD_IESR_IESR_0              	BIT0

;; GPIOD_RAWDATA Bit-Fields:
 set GPIOD_RAWDATA_RAWDATA          	(BIT3+BIT2+BIT1+BIT0)
 set GPIOD_RAWDATA_RAWDATA_3        	BIT3
 set GPIOD_RAWDATA_RAWDATA_2        	BIT2
 set GPIOD_RAWDATA_RAWDATA_1        	BIT1
 set GPIOD_RAWDATA_RAWDATA_0        	BIT0

;; GPIOD_DRIVE Bit-Fields:
 set GPIOD_DRIVE_DRIVE              	(BIT3+BIT2+BIT1+BIT0)
 set GPIOD_DRIVE_DRIVE_3            	BIT3
 set GPIOD_DRIVE_DRIVE_2            	BIT2
 set GPIOD_DRIVE_DRIVE_1            	BIT1
 set GPIOD_DRIVE_DRIVE_0            	BIT0

;; GPIOD_IFE Bit-Fields:
 set GPIOD_IFE_IFE                  	(BIT3+BIT2+BIT1+BIT0)
 set GPIOD_IFE_IFE_3                	BIT3
 set GPIOD_IFE_IFE_2                	BIT2
 set GPIOD_IFE_IFE_1                	BIT1
 set GPIOD_IFE_IFE_0                	BIT0

;; GPIOD_SLEW Bit-Fields:
 set GPIOD_SLEW_SLEW                	(BIT3+BIT2+BIT1+BIT0)
 set GPIOD_SLEW_SLEW_3              	BIT3
 set GPIOD_SLEW_SLEW_2              	BIT2
 set GPIOD_SLEW_SLEW_1              	BIT1
 set GPIOD_SLEW_SLEW_0              	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; GPIOE Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; GPIOE_PUR Bit-Fields:
 set GPIOE_PUR_PUR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOE_PUR_PUR_7                	BIT7
 set GPIOE_PUR_PUR_6                	BIT6
 set GPIOE_PUR_PUR_5                	BIT5
 set GPIOE_PUR_PUR_4                	BIT4
 set GPIOE_PUR_PUR_3                	BIT3
 set GPIOE_PUR_PUR_2                	BIT2
 set GPIOE_PUR_PUR_1                	BIT1
 set GPIOE_PUR_PUR_0                	BIT0

;; GPIOE_DR Bit-Fields:
 set GPIOE_DR_DR                    	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOE_DR_DR_7                  	BIT7
 set GPIOE_DR_DR_6                  	BIT6
 set GPIOE_DR_DR_5                  	BIT5
 set GPIOE_DR_DR_4                  	BIT4
 set GPIOE_DR_DR_3                  	BIT3
 set GPIOE_DR_DR_2                  	BIT2
 set GPIOE_DR_DR_1                  	BIT1
 set GPIOE_DR_DR_0                  	BIT0

;; GPIOE_DDR Bit-Fields:
 set GPIOE_DDR_DDR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOE_DDR_DDR_7                	BIT7
 set GPIOE_DDR_DDR_6                	BIT6
 set GPIOE_DDR_DDR_5                	BIT5
 set GPIOE_DDR_DDR_4                	BIT4
 set GPIOE_DDR_DDR_3                	BIT3
 set GPIOE_DDR_DDR_2                	BIT2
 set GPIOE_DDR_DDR_1                	BIT1
 set GPIOE_DDR_DDR_0                	BIT0

;; GPIOE_PER Bit-Fields:
 set GPIOE_PER_PER                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOE_PER_PER_7                	BIT7
 set GPIOE_PER_PER_6                	BIT6
 set GPIOE_PER_PER_5                	BIT5
 set GPIOE_PER_PER_4                	BIT4
 set GPIOE_PER_PER_3                	BIT3
 set GPIOE_PER_PER_2                	BIT2
 set GPIOE_PER_PER_1                	BIT1
 set GPIOE_PER_PER_0                	BIT0

;; GPIOE_IENR Bit-Fields:
 set GPIOE_IENR_IENR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOE_IENR_IENR_7              	BIT7
 set GPIOE_IENR_IENR_6              	BIT6
 set GPIOE_IENR_IENR_5              	BIT5
 set GPIOE_IENR_IENR_4              	BIT4
 set GPIOE_IENR_IENR_3              	BIT3
 set GPIOE_IENR_IENR_2              	BIT2
 set GPIOE_IENR_IENR_1              	BIT1
 set GPIOE_IENR_IENR_0              	BIT0

;; GPIOE_IPOLR Bit-Fields:
 set GPIOE_IPOLR_IPOLR              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOE_IPOLR_IPOLR_7            	BIT7
 set GPIOE_IPOLR_IPOLR_6            	BIT6
 set GPIOE_IPOLR_IPOLR_5            	BIT5
 set GPIOE_IPOLR_IPOLR_4            	BIT4
 set GPIOE_IPOLR_IPOLR_3            	BIT3
 set GPIOE_IPOLR_IPOLR_2            	BIT2
 set GPIOE_IPOLR_IPOLR_1            	BIT1
 set GPIOE_IPOLR_IPOLR_0            	BIT0

;; GPIOE_IPR Bit-Fields:
 set GPIOE_IPR_IPR                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOE_IPR_IPR_7                	BIT7
 set GPIOE_IPR_IPR_6                	BIT6
 set GPIOE_IPR_IPR_5                	BIT5
 set GPIOE_IPR_IPR_4                	BIT4
 set GPIOE_IPR_IPR_3                	BIT3
 set GPIOE_IPR_IPR_2                	BIT2
 set GPIOE_IPR_IPR_1                	BIT1
 set GPIOE_IPR_IPR_0                	BIT0

;; GPIOE_IESR Bit-Fields:
 set GPIOE_IESR_IESR                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOE_IESR_IESR_7              	BIT7
 set GPIOE_IESR_IESR_6              	BIT6
 set GPIOE_IESR_IESR_5              	BIT5
 set GPIOE_IESR_IESR_4              	BIT4
 set GPIOE_IESR_IESR_3              	BIT3
 set GPIOE_IESR_IESR_2              	BIT2
 set GPIOE_IESR_IESR_1              	BIT1
 set GPIOE_IESR_IESR_0              	BIT0

;; GPIOE_RAWDATA Bit-Fields:
 set GPIOE_RAWDATA_RAWDATA          	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOE_RAWDATA_RAWDATA_7        	BIT7
 set GPIOE_RAWDATA_RAWDATA_6        	BIT6
 set GPIOE_RAWDATA_RAWDATA_5        	BIT5
 set GPIOE_RAWDATA_RAWDATA_4        	BIT4
 set GPIOE_RAWDATA_RAWDATA_3        	BIT3
 set GPIOE_RAWDATA_RAWDATA_2        	BIT2
 set GPIOE_RAWDATA_RAWDATA_1        	BIT1
 set GPIOE_RAWDATA_RAWDATA_0        	BIT0

;; GPIOE_DRIVE Bit-Fields:
 set GPIOE_DRIVE_DRIVE              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOE_DRIVE_DRIVE_7            	BIT7
 set GPIOE_DRIVE_DRIVE_6            	BIT6
 set GPIOE_DRIVE_DRIVE_5            	BIT5
 set GPIOE_DRIVE_DRIVE_4            	BIT4
 set GPIOE_DRIVE_DRIVE_3            	BIT3
 set GPIOE_DRIVE_DRIVE_2            	BIT2
 set GPIOE_DRIVE_DRIVE_1            	BIT1
 set GPIOE_DRIVE_DRIVE_0            	BIT0

;; GPIOE_IFE Bit-Fields:
 set GPIOE_IFE_IFE                  	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOE_IFE_IFE_7                	BIT7
 set GPIOE_IFE_IFE_6                	BIT6
 set GPIOE_IFE_IFE_5                	BIT5
 set GPIOE_IFE_IFE_4                	BIT4
 set GPIOE_IFE_IFE_3                	BIT3
 set GPIOE_IFE_IFE_2                	BIT2
 set GPIOE_IFE_IFE_1                	BIT1
 set GPIOE_IFE_IFE_0                	BIT0

;; GPIOE_SLEW Bit-Fields:
 set GPIOE_SLEW_SLEW                	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set GPIOE_SLEW_SLEW_7              	BIT7
 set GPIOE_SLEW_SLEW_6              	BIT6
 set GPIOE_SLEW_SLEW_5              	BIT5
 set GPIOE_SLEW_SLEW_4              	BIT4
 set GPIOE_SLEW_SLEW_3              	BIT3
 set GPIOE_SLEW_SLEW_2              	BIT2
 set GPIOE_SLEW_SLEW_1              	BIT1
 set GPIOE_SLEW_SLEW_0              	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; GPIOF Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; GPIOF_PUR Bit-Fields:
 set GPIOF_PUR_PUR                  	(BIT3+BIT2+BIT1+BIT0)
 set GPIOF_PUR_PUR_3                	BIT3
 set GPIOF_PUR_PUR_2                	BIT2
 set GPIOF_PUR_PUR_1                	BIT1
 set GPIOF_PUR_PUR_0                	BIT0

;; GPIOF_DR Bit-Fields:
 set GPIOF_DR_DR                    	(BIT3+BIT2+BIT1+BIT0)
 set GPIOF_DR_DR_3                  	BIT3
 set GPIOF_DR_DR_2                  	BIT2
 set GPIOF_DR_DR_1                  	BIT1
 set GPIOF_DR_DR_0                  	BIT0

;; GPIOF_DDR Bit-Fields:
 set GPIOF_DDR_DDR                  	(BIT3+BIT2+BIT1+BIT0)
 set GPIOF_DDR_DDR_3                	BIT3
 set GPIOF_DDR_DDR_2                	BIT2
 set GPIOF_DDR_DDR_1                	BIT1
 set GPIOF_DDR_DDR_0                	BIT0

;; GPIOF_PER Bit-Fields:
 set GPIOF_PER_PER                  	(BIT3+BIT2+BIT1+BIT0)
 set GPIOF_PER_PER_3                	BIT3
 set GPIOF_PER_PER_2                	BIT2
 set GPIOF_PER_PER_1                	BIT1
 set GPIOF_PER_PER_0                	BIT0

;; GPIOF_IENR Bit-Fields:
 set GPIOF_IENR_IENR                	(BIT3+BIT2+BIT1+BIT0)
 set GPIOF_IENR_IENR_3              	BIT3
 set GPIOF_IENR_IENR_2              	BIT2
 set GPIOF_IENR_IENR_1              	BIT1
 set GPIOF_IENR_IENR_0              	BIT0

;; GPIOF_IPOLR Bit-Fields:
 set GPIOF_IPOLR_IPOLR              	(BIT3+BIT2+BIT1+BIT0)
 set GPIOF_IPOLR_IPOLR_3            	BIT3
 set GPIOF_IPOLR_IPOLR_2            	BIT2
 set GPIOF_IPOLR_IPOLR_1            	BIT1
 set GPIOF_IPOLR_IPOLR_0            	BIT0

;; GPIOF_IPR Bit-Fields:
 set GPIOF_IPR_IPR                  	(BIT3+BIT2+BIT1+BIT0)
 set GPIOF_IPR_IPR_3                	BIT3
 set GPIOF_IPR_IPR_2                	BIT2
 set GPIOF_IPR_IPR_1                	BIT1
 set GPIOF_IPR_IPR_0                	BIT0

;; GPIOF_IESR Bit-Fields:
 set GPIOF_IESR_IESR                	(BIT3+BIT2+BIT1+BIT0)
 set GPIOF_IESR_IESR_3              	BIT3
 set GPIOF_IESR_IESR_2              	BIT2
 set GPIOF_IESR_IESR_1              	BIT1
 set GPIOF_IESR_IESR_0              	BIT0

;; GPIOF_RAWDATA Bit-Fields:
 set GPIOF_RAWDATA_RAWDATA          	(BIT3+BIT2+BIT1+BIT0)
 set GPIOF_RAWDATA_RAWDATA_3        	BIT3
 set GPIOF_RAWDATA_RAWDATA_2        	BIT2
 set GPIOF_RAWDATA_RAWDATA_1        	BIT1
 set GPIOF_RAWDATA_RAWDATA_0        	BIT0

;; GPIOF_DRIVE Bit-Fields:
 set GPIOF_DRIVE_DRIVE              	(BIT3+BIT2+BIT1+BIT0)
 set GPIOF_DRIVE_DRIVE_3            	BIT3
 set GPIOF_DRIVE_DRIVE_2            	BIT2
 set GPIOF_DRIVE_DRIVE_1            	BIT1
 set GPIOF_DRIVE_DRIVE_0            	BIT0

;; GPIOF_IFE Bit-Fields:
 set GPIOF_IFE_IFE                  	(BIT3+BIT2+BIT1+BIT0)
 set GPIOF_IFE_IFE_3                	BIT3
 set GPIOF_IFE_IFE_2                	BIT2
 set GPIOF_IFE_IFE_1                	BIT1
 set GPIOF_IFE_IFE_0                	BIT0

;; GPIOF_SLEW Bit-Fields:
 set GPIOF_SLEW_SLEW                	(BIT3+BIT2+BIT1+BIT0)
 set GPIOF_SLEW_SLEW_3              	BIT3
 set GPIOF_SLEW_SLEW_2              	BIT2
 set GPIOF_SLEW_SLEW_1              	BIT1
 set GPIOF_SLEW_SLEW_0              	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SIM Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; SIM_CTRL Bit-Fields:
 set SIM_CTRL_Once_Ebl              	BIT5
 set SIM_CTRL_SW_Rst                	BIT4
 set SIM_CTRL_STOP_disable          	(BIT3+BIT2)
 set SIM_CTRL_STOP_disable_1        	BIT3
 set SIM_CTRL_STOP_disable_0        	BIT2
 set SIM_CTRL_WAIT_disable          	(BIT1+BIT0)
 set SIM_CTRL_WAIT_disable_1        	BIT1
 set SIM_CTRL_WAIT_disable_0        	BIT0

;; SIM_RSTAT Bit-Fields:
 set SIM_RSTAT_SWR                  	BIT6
 set SIM_RSTAT_COP_CPU              	BIT5
 set SIM_RSTAT_COP_LOR              	BIT4
 set SIM_RSTAT_EXTR                 	BIT3
 set SIM_RSTAT_LVDR                 	BIT2
 set SIM_RSTAT_PPD                  	BIT1
 set SIM_RSTAT_POR                  	BIT0

;; SIM_MSHID Bit-Fields:

;; SIM_LSHID Bit-Fields:

;; SIM_TEST Bit-Fields:
 set SIM_TEST_TRS                   	(BIT15+BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7)
 set SIM_TEST_TRS_8                 	BIT15
 set SIM_TEST_TRS_7                 	BIT14
 set SIM_TEST_TRS_6                 	BIT13
 set SIM_TEST_TRS_5                 	BIT12
 set SIM_TEST_TRS_4                 	BIT11
 set SIM_TEST_TRS_3                 	BIT10
 set SIM_TEST_TRS_2                 	BIT9
 set SIM_TEST_TRS_1                 	BIT8
 set SIM_TEST_TRS_0                 	BIT7
 set SIM_TEST_Test_INT              	BIT6
 set SIM_TEST_Test_STOP             	BIT5
 set SIM_TEST_Test_WAIT             	BIT4
 set SIM_TEST_Test_CLKO             	BIT3
 set SIM_TEST_PG_Obs                	BIT1
 set SIM_TEST_CLO_Obs               	BIT0

;; SIM_CLKOUT Bit-Fields:
 set SIM_CLKOUT_CLKDIS1             	BIT13
 set SIM_CLKOUT_CLKOSEL1            	(BIT10+BIT9+BIT8)
 set SIM_CLKOUT_CLKOSEL1_2          	BIT10
 set SIM_CLKOUT_CLKOSEL1_1          	BIT9
 set SIM_CLKOUT_CLKOSEL1_0          	BIT8
 set SIM_CLKOUT_CLKDIS0             	BIT5
 set SIM_CLKOUT_CLKOSEL0            	(BIT4+BIT3+BIT2+BIT1+BIT0)
 set SIM_CLKOUT_CLKOSEL0_4          	BIT4
 set SIM_CLKOUT_CLKOSEL0_3          	BIT3
 set SIM_CLKOUT_CLKOSEL0_2          	BIT2
 set SIM_CLKOUT_CLKOSEL0_1          	BIT1
 set SIM_CLKOUT_CLKOSEL0_0          	BIT0

;; SIM_PCR Bit-Fields:
 set SIM_PCR_TMR_CR                 	BIT15
 set SIM_PCR_PWM_CR                 	BIT13
 set SIM_PCR_SCI_CR                 	BIT12

;; SIM_PCE Bit-Fields:
 set SIM_PCE_CMP2                   	BIT15
 set SIM_PCE_CMP1                   	BIT14
 set SIM_PCE_CMP0                   	BIT13
 set SIM_PCE_ADC1                   	BIT12
 set SIM_PCE_ADC0                   	BIT11
 set SIM_PCE_PGA1                   	BIT10
 set SIM_PCE_PGA0                   	BIT9
 set SIM_PCE_I2C                    	BIT8
 set SIM_PCE_SCI                    	BIT7
 set SIM_PCE_SPI                    	BIT6
 set SIM_PCE_PWM                    	BIT5
 set SIM_PCE_COP                    	BIT4
 set SIM_PCE_PDB                    	BIT3
 set SIM_PCE_PIT                    	BIT2
 set SIM_PCE_TA1                    	BIT1
 set SIM_PCE_TA0                    	BIT0

;; SIM_SDR Bit-Fields:
 set SIM_SDR_CMP2                   	BIT15
 set SIM_SDR_CMP1                   	BIT14
 set SIM_SDR_CMP0                   	BIT13
 set SIM_SDR_ADC1                   	BIT12
 set SIM_SDR_ADC0                   	BIT11
 set SIM_SDR_PGA1                   	BIT10
 set SIM_SDR_PGA0                   	BIT9
 set SIM_SDR_I2C                    	BIT8
 set SIM_SDR_SCI                    	BIT7
 set SIM_SDR_SPI                    	BIT6
 set SIM_SDR_PWM                    	BIT5
 set SIM_SDR_COP                    	BIT4
 set SIM_SDR_PDB                    	BIT3
 set SIM_SDR_PIT                    	BIT2
 set SIM_SDR_TA1                    	BIT1
 set SIM_SDR_TA0                    	BIT0

;; SIM_ISAL Bit-Fields:
 set SIM_ISAL_ADDR_15_6             	(BIT15+BIT14+BIT13+BIT12+BIT11+BIT10+BIT9+BIT8+BIT7+BIT6)
 set SIM_ISAL_ADDR_15_6_9           	BIT15
 set SIM_ISAL_ADDR_15_6_8           	BIT14
 set SIM_ISAL_ADDR_15_6_7           	BIT13
 set SIM_ISAL_ADDR_15_6_6           	BIT12
 set SIM_ISAL_ADDR_15_6_5           	BIT11
 set SIM_ISAL_ADDR_15_6_4           	BIT10
 set SIM_ISAL_ADDR_15_6_3           	BIT9
 set SIM_ISAL_ADDR_15_6_2           	BIT8
 set SIM_ISAL_ADDR_15_6_1           	BIT7
 set SIM_ISAL_ADDR_15_6_0           	BIT6

;; SIM_PROT Bit-Fields:
 set SIM_PROT_PCEP                  	(BIT3+BIT2)
 set SIM_PROT_PCEP_1                	BIT3
 set SIM_PROT_PCEP_0                	BIT2
 set SIM_PROT_GIPSP                 	(BIT1+BIT0)
 set SIM_PROT_GIPSP_1               	BIT1
 set SIM_PROT_GIPSP_0               	BIT0

;; SIM_GPSA Bit-Fields:
 set SIM_GPSA_GPS_A6                	(BIT8+BIT7+BIT6)
 set SIM_GPSA_GPS_A6_2              	BIT8
 set SIM_GPSA_GPS_A6_1              	BIT7
 set SIM_GPSA_GPS_A6_0              	BIT6
 set SIM_GPSA_GPS_A5                	(BIT5+BIT4)
 set SIM_GPSA_GPS_A5_1              	BIT5
 set SIM_GPSA_GPS_A5_0              	BIT4
 set SIM_GPSA_GPS_A4                	(BIT3+BIT2)
 set SIM_GPSA_GPS_A4_1              	BIT3
 set SIM_GPSA_GPS_A4_0              	BIT2
 set SIM_GPSA_GPS_A3                	(BIT1+BIT0)
 set SIM_GPSA_GPS_A3_1              	BIT1
 set SIM_GPSA_GPS_A3_0              	BIT0

;; SIM_GPSB0 Bit-Fields:
 set SIM_GPSB0_GPS_B5               	(BIT15+BIT14)
 set SIM_GPSB0_GPS_B5_1             	BIT15
 set SIM_GPSB0_GPS_B5_0             	BIT14
 set SIM_GPSB0_GPS_B4               	(BIT13+BIT12+BIT11)
 set SIM_GPSB0_GPS_B4_2             	BIT13
 set SIM_GPSB0_GPS_B4_1             	BIT12
 set SIM_GPSB0_GPS_B4_0             	BIT11
 set SIM_GPSB0_GPS_B3               	(BIT10+BIT9+BIT8)
 set SIM_GPSB0_GPS_B3_2             	BIT10
 set SIM_GPSB0_GPS_B3_1             	BIT9
 set SIM_GPSB0_GPS_B3_0             	BIT8
 set SIM_GPSB0_GPS_B2               	(BIT7+BIT6)
 set SIM_GPSB0_GPS_B2_1             	BIT7
 set SIM_GPSB0_GPS_B2_0             	BIT6
 set SIM_GPSB0_GPS_B1               	(BIT4+BIT3)
 set SIM_GPSB0_GPS_B1_1             	BIT4
 set SIM_GPSB0_GPS_B1_0             	BIT3
 set SIM_GPSB0_GPS_B0               	(BIT2+BIT1+BIT0)
 set SIM_GPSB0_GPS_B0_2             	BIT2
 set SIM_GPSB0_GPS_B0_1             	BIT1
 set SIM_GPSB0_GPS_B0_0             	BIT0

;; SIM_GPSB1 Bit-Fields:
 set SIM_GPSB1_GPS_B7               	(BIT3+BIT2)
 set SIM_GPSB1_GPS_B7_1             	BIT3
 set SIM_GPSB1_GPS_B7_0             	BIT2
 set SIM_GPSB1_GPS_B6               	(BIT1+BIT0)
 set SIM_GPSB1_GPS_B6_1             	BIT1
 set SIM_GPSB1_GPS_B6_0             	BIT0

;; SIM_GPSC Bit-Fields:
 set SIM_GPSC_GPS_C6                	BIT1
 set SIM_GPSC_GPS_C0                	BIT0

;; SIM_GPSD Bit-Fields:
 set SIM_GPSD_GPS_D3                	(BIT8+BIT7)
 set SIM_GPSD_GPS_D3_1              	BIT8
 set SIM_GPSD_GPS_D3_0              	BIT7
 set SIM_GPSD_GPS_D2                	(BIT6+BIT5)
 set SIM_GPSD_GPS_D2_1              	BIT6
 set SIM_GPSD_GPS_D2_0              	BIT5
 set SIM_GPSD_GPS_D1                	(BIT4+BIT3)
 set SIM_GPSD_GPS_D1_1              	BIT4
 set SIM_GPSD_GPS_D1_0              	BIT3
 set SIM_GPSD_GPS_D0                	(BIT2+BIT1+BIT0)
 set SIM_GPSD_GPS_D0_2              	BIT2
 set SIM_GPSD_GPS_D0_1              	BIT1
 set SIM_GPSD_GPS_D0_0              	BIT0

;; SIM_IPS0 Bit-Fields:
 set SIM_IPS0_IPS_FAULT3            	BIT11
 set SIM_IPS0_IPS_FAULT2            	BIT10
 set SIM_IPS0_IPS_FAULT1            	BIT9
 set SIM_IPS0_IPS_PSRC2             	(BIT8+BIT7+BIT6)
 set SIM_IPS0_IPS_PSRC2_2           	BIT8
 set SIM_IPS0_IPS_PSRC2_1           	BIT7
 set SIM_IPS0_IPS_PSRC2_0           	BIT6
 set SIM_IPS0_IPS_PSRC1             	(BIT5+BIT4+BIT3)
 set SIM_IPS0_IPS_PSRC1_2           	BIT5
 set SIM_IPS0_IPS_PSRC1_1           	BIT4
 set SIM_IPS0_IPS_PSRC1_0           	BIT3
 set SIM_IPS0_IPS_PSRC0             	(BIT2+BIT1+BIT0)
 set SIM_IPS0_IPS_PSRC0_2           	BIT2
 set SIM_IPS0_IPS_PSRC0_1           	BIT1
 set SIM_IPS0_IPS_PSRC0_0           	BIT0

;; SIM_IPS1 Bit-Fields:
 set SIM_IPS1_IPS_C2_WS             	(BIT14+BIT13+BIT12)
 set SIM_IPS1_IPS_C2_WS_2           	BIT14
 set SIM_IPS1_IPS_C2_WS_1           	BIT13
 set SIM_IPS1_IPS_C2_WS_0           	BIT12
 set SIM_IPS1_IPS_C1_WS             	(BIT11+BIT10+BIT9)
 set SIM_IPS1_IPS_C1_WS_2           	BIT11
 set SIM_IPS1_IPS_C1_WS_1           	BIT10
 set SIM_IPS1_IPS_C1_WS_0           	BIT9
 set SIM_IPS1_IPS_C0_WS             	(BIT8+BIT7+BIT6)
 set SIM_IPS1_IPS_C0_WS_2           	BIT8
 set SIM_IPS1_IPS_C0_WS_1           	BIT7
 set SIM_IPS1_IPS_C0_WS_0           	BIT6
 set SIM_IPS1_IPS_T1                	(BIT5+BIT4+BIT3)
 set SIM_IPS1_IPS_T1_2              	BIT5
 set SIM_IPS1_IPS_T1_1              	BIT4
 set SIM_IPS1_IPS_T1_0              	BIT3
 set SIM_IPS1_IPS_T0                	(BIT2+BIT1+BIT0)
 set SIM_IPS1_IPS_T0_2              	BIT2
 set SIM_IPS1_IPS_T0_1              	BIT1
 set SIM_IPS1_IPS_T0_0              	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; PMC Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; PMC_SCR Bit-Fields:
 set PMC_SCR_OORF                   	BIT15
 set PMC_SCR_LVDF                   	BIT14
 set PMC_SCR_PPDF                   	BIT13
 set PMC_SCR_PORF                   	BIT12
 set PMC_SCR_OORIE                  	BIT11
 set PMC_SCR_LVDIE                  	BIT10
 set PMC_SCR_LVDRE                  	BIT9
 set PMC_SCR_PPDE                   	BIT8
 set PMC_SCR_LPR                    	BIT7
 set PMC_SCR_LPRS                   	BIT6
 set PMC_SCR_LPWUI                  	BIT5
 set PMC_SCR_BGBE                   	BIT4
 set PMC_SCR_LVDE                   	BIT3
 set PMC_SCR_LVLS                   	BIT2
 set PMC_SCR_PROT                   	(BIT1+BIT0)
 set PMC_SCR_PROT_1                 	BIT1
 set PMC_SCR_PROT_0                 	BIT0

;; PMC_CR2 Bit-Fields:
 set PMC_CR2_LPO_EN                 	BIT8
 set PMC_CR2_LPO_TRIM               	(BIT7+BIT6+BIT5)
 set PMC_CR2_LPO_TRIM_2             	BIT7
 set PMC_CR2_LPO_TRIM_1             	BIT6
 set PMC_CR2_LPO_TRIM_0             	BIT5
 set PMC_CR2_TRIM                   	(BIT4+BIT3+BIT2+BIT1+BIT0)
 set PMC_CR2_TRIM_4                 	BIT4
 set PMC_CR2_TRIM_3                 	BIT3
 set PMC_CR2_TRIM_2                 	BIT2
 set PMC_CR2_TRIM_1                 	BIT1
 set PMC_CR2_TRIM_0                 	BIT0

;; PMC_TESTSC Bit-Fields:
 set PMC_TESTSC_LVDS                	BIT7
 set PMC_TESTSC_LVWS                	BIT6
 set PMC_TESTSC_VRP                 	BIT4
 set PMC_TESTSC_PMCTE               	BIT2
 set PMC_TESTSC_LVDFRC              	BIT1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; CMP0 Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; CMP0_CR0 Bit-Fields:
 set CMP0_CR0_FILTER_CNT            	(BIT6+BIT5+BIT4)
 set CMP0_CR0_FILTER_CNT_2          	BIT6
 set CMP0_CR0_FILTER_CNT_1          	BIT5
 set CMP0_CR0_FILTER_CNT_0          	BIT4
 set CMP0_CR0_PMC                   	(BIT3+BIT2)
 set CMP0_CR0_PMC_1                 	BIT3
 set CMP0_CR0_PMC_0                 	BIT2
 set CMP0_CR0_MMC                   	(BIT1+BIT0)
 set CMP0_CR0_MMC_1                 	BIT1
 set CMP0_CR0_MMC_0                 	BIT0

;; CMP0_CR1 Bit-Fields:
 set CMP0_CR1_SE                    	BIT7
 set CMP0_CR1_WE                    	BIT6
 set CMP0_CR1_PMODE                 	BIT4
 set CMP0_CR1_INV                   	BIT3
 set CMP0_CR1_COS                   	BIT2
 set CMP0_CR1_OPE                   	BIT1
 set CMP0_CR1_EN                    	BIT0

;; CMP0_FPR Bit-Fields:
 set CMP0_FPR_FILT_PER              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set CMP0_FPR_FILT_PER_7            	BIT7
 set CMP0_FPR_FILT_PER_6            	BIT6
 set CMP0_FPR_FILT_PER_5            	BIT5
 set CMP0_FPR_FILT_PER_4            	BIT4
 set CMP0_FPR_FILT_PER_3            	BIT3
 set CMP0_FPR_FILT_PER_2            	BIT2
 set CMP0_FPR_FILT_PER_1            	BIT1
 set CMP0_FPR_FILT_PER_0            	BIT0

;; CMP0_SCR Bit-Fields:
 set CMP0_SCR_IER                   	BIT4
 set CMP0_SCR_IEF                   	BIT3
 set CMP0_SCR_CFR                   	BIT2
 set CMP0_SCR_CFF                   	BIT1
 set CMP0_SCR_COUT                  	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; CMP1 Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; CMP1_CR0 Bit-Fields:
 set CMP1_CR0_FILTER_CNT            	(BIT6+BIT5+BIT4)
 set CMP1_CR0_FILTER_CNT_2          	BIT6
 set CMP1_CR0_FILTER_CNT_1          	BIT5
 set CMP1_CR0_FILTER_CNT_0          	BIT4
 set CMP1_CR0_PMC                   	(BIT3+BIT2)
 set CMP1_CR0_PMC_1                 	BIT3
 set CMP1_CR0_PMC_0                 	BIT2
 set CMP1_CR0_MMC                   	(BIT1+BIT0)
 set CMP1_CR0_MMC_1                 	BIT1
 set CMP1_CR0_MMC_0                 	BIT0

;; CMP1_CR1 Bit-Fields:
 set CMP1_CR1_SE                    	BIT7
 set CMP1_CR1_WE                    	BIT6
 set CMP1_CR1_PMODE                 	BIT4
 set CMP1_CR1_INV                   	BIT3
 set CMP1_CR1_COS                   	BIT2
 set CMP1_CR1_OPE                   	BIT1
 set CMP1_CR1_EN                    	BIT0

;; CMP1_FPR Bit-Fields:
 set CMP1_FPR_FILT_PER              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set CMP1_FPR_FILT_PER_7            	BIT7
 set CMP1_FPR_FILT_PER_6            	BIT6
 set CMP1_FPR_FILT_PER_5            	BIT5
 set CMP1_FPR_FILT_PER_4            	BIT4
 set CMP1_FPR_FILT_PER_3            	BIT3
 set CMP1_FPR_FILT_PER_2            	BIT2
 set CMP1_FPR_FILT_PER_1            	BIT1
 set CMP1_FPR_FILT_PER_0            	BIT0

;; CMP1_SCR Bit-Fields:
 set CMP1_SCR_IER                   	BIT4
 set CMP1_SCR_IEF                   	BIT3
 set CMP1_SCR_CFR                   	BIT2
 set CMP1_SCR_CFF                   	BIT1
 set CMP1_SCR_COUT                  	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; CMP2 Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; CMP2_CR0 Bit-Fields:
 set CMP2_CR0_FILTER_CNT            	(BIT6+BIT5+BIT4)
 set CMP2_CR0_FILTER_CNT_2          	BIT6
 set CMP2_CR0_FILTER_CNT_1          	BIT5
 set CMP2_CR0_FILTER_CNT_0          	BIT4
 set CMP2_CR0_PMC                   	(BIT3+BIT2)
 set CMP2_CR0_PMC_1                 	BIT3
 set CMP2_CR0_PMC_0                 	BIT2
 set CMP2_CR0_MMC                   	(BIT1+BIT0)
 set CMP2_CR0_MMC_1                 	BIT1
 set CMP2_CR0_MMC_0                 	BIT0

;; CMP2_CR1 Bit-Fields:
 set CMP2_CR1_SE                    	BIT7
 set CMP2_CR1_WE                    	BIT6
 set CMP2_CR1_PMODE                 	BIT4
 set CMP2_CR1_INV                   	BIT3
 set CMP2_CR1_COS                   	BIT2
 set CMP2_CR1_OPE                   	BIT1
 set CMP2_CR1_EN                    	BIT0

;; CMP2_FPR Bit-Fields:
 set CMP2_FPR_FILT_PER              	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set CMP2_FPR_FILT_PER_7            	BIT7
 set CMP2_FPR_FILT_PER_6            	BIT6
 set CMP2_FPR_FILT_PER_5            	BIT5
 set CMP2_FPR_FILT_PER_4            	BIT4
 set CMP2_FPR_FILT_PER_3            	BIT3
 set CMP2_FPR_FILT_PER_2            	BIT2
 set CMP2_FPR_FILT_PER_1            	BIT1
 set CMP2_FPR_FILT_PER_0            	BIT0

;; CMP2_SCR Bit-Fields:
 set CMP2_SCR_IER                   	BIT4
 set CMP2_SCR_IEF                   	BIT3
 set CMP2_SCR_CFR                   	BIT2
 set CMP2_SCR_CFF                   	BIT1
 set CMP2_SCR_COUT                  	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; PIT Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; PIT_CTRL Bit-Fields:
 set PIT_CTRL_PRESCALER             	(BIT6+BIT5+BIT4+BIT3)
 set PIT_CTRL_PRESCALER_3           	BIT6
 set PIT_CTRL_PRESCALER_2           	BIT5
 set PIT_CTRL_PRESCALER_1           	BIT4
 set PIT_CTRL_PRESCALER_0           	BIT3
 set PIT_CTRL_PRF                   	BIT2
 set PIT_CTRL_PRIE                  	BIT1
 set PIT_CTRL_CNT_EN                	BIT0

;; PIT_MOD Bit-Fields:
 set PIT_MOD_MODULO_VALUE           	$FFFF

;; PIT_CNTR Bit-Fields:
 set PIT_CNTR_COUNTER_VALUE         	$FFFF

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; PDB Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; PDB_SCR Bit-Fields:
 set PDB_SCR_PRESCALAR              	(BIT15+BIT14+BIT13)
 set PDB_SCR_PRESCALAR_2            	BIT15
 set PDB_SCR_PRESCALAR_1            	BIT14
 set PDB_SCR_PRESCALAR_0            	BIT13
 set PDB_SCR_AOS                    	(BIT11+BIT10)
 set PDB_SCR_AOS_1                  	BIT11
 set PDB_SCR_AOS_0                  	BIT10
 set PDB_SCR_BOS                    	(BIT8+BIT7)
 set PDB_SCR_BOS_1                  	BIT8
 set PDB_SCR_BOS_0                  	BIT7
 set PDB_SCR_CONT                   	BIT6
 set PDB_SCR_SWTRIG                 	BIT5
 set PDB_SCR_TRIGSEL                	(BIT4+BIT3+BIT2)
 set PDB_SCR_TRIGSEL_2              	BIT4
 set PDB_SCR_TRIGSEL_1              	BIT3
 set PDB_SCR_TRIGSEL_0              	BIT2
 set PDB_SCR_ENA                    	BIT1
 set PDB_SCR_ENB                    	BIT0

;; PDB_DELAYA Bit-Fields:
 set PDB_DELAYA_DELAYA              	$FFFF

;; PDB_DELAYB Bit-Fields:
 set PDB_DELAYB_DELAYB              	$FFFF

;; PDB_MOD Bit-Fields:
 set PDB_MOD_MOD                    	$FFFF

;; PDB_COUNT Bit-Fields:
 set PDB_COUNT_COUNT                	$FFFF

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; RTC Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; RTC_SC Bit-Fields:
 set RTC_SC_RTIF                    	BIT7
 set RTC_SC_RTCLKS                  	(BIT6+BIT5)
 set RTC_SC_RTCLKS_1                	BIT6
 set RTC_SC_RTCLKS_0                	BIT5
 set RTC_SC_RTIE                    	BIT4
 set RTC_SC_RTCPS                   	(BIT3+BIT2+BIT1+BIT0)
 set RTC_SC_RTCPS_3                 	BIT3
 set RTC_SC_RTCPS_2                 	BIT2
 set RTC_SC_RTCPS_1                 	BIT1
 set RTC_SC_RTCPS_0                 	BIT0

;; RTC_CNT Bit-Fields:
 set RTC_CNT_RTCCNT                 	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set RTC_CNT_RTCCNT_7               	BIT7
 set RTC_CNT_RTCCNT_6               	BIT6
 set RTC_CNT_RTCCNT_5               	BIT5
 set RTC_CNT_RTCCNT_4               	BIT4
 set RTC_CNT_RTCCNT_3               	BIT3
 set RTC_CNT_RTCCNT_2               	BIT2
 set RTC_CNT_RTCCNT_1               	BIT1
 set RTC_CNT_RTCCNT_0               	BIT0

;; RTC_MOD Bit-Fields:
 set RTC_MOD_RTCMOD                 	(BIT7+BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set RTC_MOD_RTCMOD_7               	BIT7
 set RTC_MOD_RTCMOD_6               	BIT6
 set RTC_MOD_RTCMOD_5               	BIT5
 set RTC_MOD_RTCMOD_4               	BIT4
 set RTC_MOD_RTCMOD_3               	BIT3
 set RTC_MOD_RTCMOD_2               	BIT2
 set RTC_MOD_RTCMOD_1               	BIT1
 set RTC_MOD_RTCMOD_0               	BIT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; HFM Peripheral Register Bit-Fields & Pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; FM_CLKDIV Bit-Fields:
 set FM_CLKDIV_DIVLD                	BIT7
 set FM_CLKDIV_PRDIV8               	BIT6
 set FM_CLKDIV_DIV                  	(BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set FM_CLKDIV_DIV_5                	BIT5
 set FM_CLKDIV_DIV_4                	BIT4
 set FM_CLKDIV_DIV_3                	BIT3
 set FM_CLKDIV_DIV_2                	BIT2
 set FM_CLKDIV_DIV_1                	BIT1
 set FM_CLKDIV_DIV_0                	BIT0

;; FM_CNFG Bit-Fields:
 set FM_CNFG_LOCK                   	BIT10
 set FM_CNFG_AEIE                   	BIT8
 set FM_CNFG_CBEIE                  	BIT7
 set FM_CNFG_CCIE                   	BIT6
 set FM_CNFG_KEYACC                 	BIT5

;; FM_TEST Bit-Fields:
 set FM_TEST_DIRECT                 	BIT0

;; FM_SECHI Bit-Fields:
 set FM_SECHI_KEYEN                 	BIT15
 set FM_SECHI_SECSTAT               	BIT14

;; FM_SECLO Bit-Fields:
 set FM_SECLO_SEC                   	(BIT1+BIT0)
 set FM_SECLO_SEC_1                 	BIT1
 set FM_SECLO_SEC_0                 	BIT0

;; FM_MONITOR Bit-Fields:
 set FM_MONITOR_HFMMNTR             	$FFFF

;; FM_PROT Bit-Fields:
 set FM_PROT_PROTECT                	$FFFF

;; FM_TSTAT Bit-Fields:
 set FM_TSTAT_FAIL                  	BIT1
 set FM_TSTAT_DONE                  	BIT0

;; FM_USTAT Bit-Fields:
 set FM_USTAT_CBEIF                 	BIT7
 set FM_USTAT_CCIF                  	BIT6
 set FM_USTAT_PVIOL                 	BIT5
 set FM_USTAT_ACCERR                	BIT4
 set FM_USTAT_BLANK                 	BIT2

;; FM_CMD Bit-Fields:
 set FM_CMD_CMD                     	(BIT6+BIT5+BIT4+BIT3+BIT2+BIT1+BIT0)
 set FM_CMD_CMD_6                   	BIT6
 set FM_CMD_CMD_5                   	BIT5
 set FM_CMD_CMD_4                   	BIT4
 set FM_CMD_CMD_3                   	BIT3
 set FM_CMD_CMD_2                   	BIT2
 set FM_CMD_CMD_1                   	BIT1
 set FM_CMD_CMD_0                   	BIT0

;; FM_CONTROL Bit-Fields:
 set FM_CONTROL_TMR                 	BIT15
 set FM_CONTROL_ERASE               	BIT7
 set FM_CONTROL_PROG                	BIT6
 set FM_CONTROL_IFREN               	BIT5
 set FM_CONTROL_NVSTR               	BIT4
 set FM_CONTROL_XE                  	BIT3
 set FM_CONTROL_YE                  	BIT2
 set FM_CONTROL_SE                      BIT1
 set FM_CONTROL_MAS1                	BIT0

;; FM_ADDR Bit-Fields:
 set FM_ADDR_HFMADR                 	$FFFF

;; FM_DATA Bit-Fields:
 set FM_DATA_HFMDATA                	$FFFF

;; FM_OPT0 Bit-Fields:
 set FM_OPT0_IFR_OPT0               	$FFFF

;; FM_OPT1 Bit-Fields:
 set FM_OPT1_IFR_OPT1               	$FFFF

;; FM_MEM_SEL Bit-Fields:
 set FM_MEM_SEL_MEM_SEL             	(BIT3+BIT2+BIT1+BIT0)
 set FM_MEM_SEL_MEM_SEL_3           	BIT3
 set FM_MEM_SEL_MEM_SEL_2           	BIT2
 set FM_MEM_SEL_MEM_SEL_1           	BIT1
 set FM_MEM_SEL_MEM_SEL_0           	BIT0

;; FM_TSTSIG Bit-Fields:
 set FM_TSTSIG_TST_AREA_SIG         	$FFFF



